/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.pagiboost.core;

import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryBackQuery;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;

public class QueryExecutionFactoryPagiboost
extends QueryExecutionFactoryBackQuery {
    private QueryExecutionFactory qef;
    private long pageExpandSize;

    @Override
    public String getId() {
        return this.qef.getId();
    }

    @Override
    public String getState() {
        return this.qef.getState();
    }

    public QueryExecutionFactoryPagiboost(QueryExecutionFactory qef, long pageExpandSize) {
        this.qef = qef;
        this.pageExpandSize = pageExpandSize;
    }

    @Override
    public QueryExecution createQueryExecution(Query query) {
        long l;
        Query q = query.cloneQuery();
        long offset = q.getOffset() == Long.MIN_VALUE ? 0L : q.getOffset();
        long limit = q.getLimit();
        long o = offset / this.pageExpandSize * this.pageExpandSize;
        if (limit != Long.MIN_VALUE) {
            long target = offset + limit;
            long t = (target / this.pageExpandSize + 1L) * this.pageExpandSize;
            l = t - o;
        } else {
            l = Long.MIN_VALUE;
        }
        long start = o - offset;
        q.setOffset(o);
        q.setLimit(l);
        QueryExecution qe = this.qef.createQueryExecution(q);
        QueryExecution result = null;
        return result;
    }
}

