/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.pagination.core;

import org.aksw.jena_sparql_api.pagination.extra.PaginationQueryIterator;
import org.apache.jena.query.Query;

public class PagingQuery {
    private Query proto;
    private Integer pageSize;

    public PagingQuery(Integer pageSize, Query proto) {
        this.proto = proto;
        this.pageSize = pageSize;
    }

    public PaginationQueryIterator createQueryIterator(Long offset, Long limit) {
        long o = offset == null ? 0L : offset;
        long l = limit == null ? Long.MAX_VALUE : limit;
        long queryOffset = this.proto.getOffset() == Long.MIN_VALUE ? 0L : this.proto.getOffset();
        long itemOffset = queryOffset + o;
        long queryLimit = this.proto.getLimit() == Long.MIN_VALUE ? Long.MAX_VALUE : this.proto.getLimit() - o;
        long itemLimit = Math.min(queryLimit, l);
        itemLimit = itemLimit == Long.MAX_VALUE ? Long.MIN_VALUE : itemLimit;
        Query clone = this.proto.cloneQuery();
        clone.setOffset(itemOffset);
        clone.setLimit(itemLimit);
        PaginationQueryIterator result = new PaginationQueryIterator(clone, this.pageSize.intValue());
        return result;
    }
}

