/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.pagination.core;

import java.util.Iterator;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactoryBackQuery;
import org.aksw.jena_sparql_api.http.QueryExecutionFactoryHttp;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionFactoryPaginated;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionIterated;
import org.aksw.jena_sparql_api.pagination.core.QueryTransformer;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;

public class QueryExecutionFactoryIterated
extends QueryExecutionFactoryBackQuery {
    private QueryExecutionFactory decoratee;
    private QueryTransformer queryTransformer;
    private boolean breakOnEmptyResult;

    public QueryExecutionFactoryIterated(QueryExecutionFactory decoratee, QueryTransformer queryTransformer, boolean breakOnEmptyResult) {
        this.decoratee = decoratee;
        this.queryTransformer = queryTransformer;
        this.breakOnEmptyResult = breakOnEmptyResult;
    }

    @Override
    public QueryExecution createQueryExecution(Query query) {
        Iterator<Query> queryIterator = this.queryTransformer.transform(query);
        return new QueryExecutionIterated(query, this.decoratee, queryIterator, this.breakOnEmptyResult);
    }

    @Override
    public String getId() {
        return this.decoratee.getId();
    }

    @Override
    public String getState() {
        return this.decoratee.getState();
    }

    public static void main(String[] args) {
        QueryExecutionFactoryHttp factory = new QueryExecutionFactoryHttp("http://linkedgeodata.org/sparql", "http://linkedgeodata.org");
        QueryExecutionFactoryPaginated fp = new QueryExecutionFactoryPaginated(factory, 10000L);
        System.out.println(fp.getPageSize());
    }
}

