/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.pagination.core;

import java.util.Iterator;
import java.util.List;
import org.aksw.commons.collections.IClosable;
import org.aksw.jena_sparql_api.core.QueryExecutionAdapter;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.pagination.core.MyQueryIteratorWrapper;
import org.aksw.jena_sparql_api.pagination.core.ResultSetPaginated;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIteratorCloseable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExecutionIterated
extends QueryExecutionAdapter {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecutionIterated.class);
    protected QueryExecutionFactory factory;
    protected Iterator<Query> queryIterator;
    protected boolean stopOnEmptyResult;
    protected IClosable currentCloseAction = null;
    protected Query originalQuery;

    public QueryExecutionIterated(Query originalQuery, QueryExecutionFactory factory, Iterator<Query> queryIterator) {
        this(originalQuery, factory, queryIterator, true);
    }

    public QueryExecutionIterated(Query originalQuery, QueryExecutionFactory factory, Iterator<Query> queryIterator, boolean stopOnEmptyResult) {
        this.originalQuery = originalQuery;
        this.queryIterator = queryIterator;
        this.factory = factory;
        this.stopOnEmptyResult = stopOnEmptyResult;
    }

    @Override
    public Query getQuery() {
        return this.originalQuery;
    }

    @Override
    public boolean execAsk() {
        Query query = this.queryIterator.next();
        query.setLimit(Long.MIN_VALUE);
        QueryExecution qe = this.factory.createQueryExecution(query);
        boolean result = qe.execAsk();
        return result;
    }

    @Override
    public ResultSet execSelect() {
        ResultSetPaginated it = new ResultSetPaginated(this.factory, this.queryIterator, this.stopOnEmptyResult);
        it.hasNext();
        ResultSet tmp = it.getCurrentResultSet();
        if (tmp == null) {
            throw new RuntimeException("Underlying result set not avaliable - probably a query failed.");
        }
        List<String> resultVars = it.getCurrentResultVars();
        MyQueryIteratorWrapper myQueryIterator = new MyQueryIteratorWrapper((Iterator<Binding>)((Object)it));
        QueryIteratorCloseable itClosable = new QueryIteratorCloseable((QueryIterator)myQueryIterator, (Closeable)it);
        ResultSet rs = ResultSetFactory.create((QueryIterator)itClosable, resultVars);
        return rs;
    }

    @Override
    public Model execConstruct() {
        return this.execConstruct(ModelFactory.createDefaultModel());
    }

    @Override
    public Model execConstruct(Model result) {
        try {
            while (this.queryIterator.hasNext()) {
                Query query = this.queryIterator.next();
                final QueryExecution current = this.factory.createQueryExecution(query);
                this.currentCloseAction = new IClosable(){

                    public void close() {
                        current.close();
                    }
                };
                logger.trace("Executing query: " + query);
                Model tmp = current.execConstruct();
                if (!tmp.isEmpty() || !this.stopOnEmptyResult) {
                    result.add(tmp);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    @Override
    public void close() {
        if (this.currentCloseAction != null) {
            this.currentCloseAction.close();
        }
    }
}

