/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.pagination.core;

import java.util.Iterator;
import java.util.List;
import org.aksw.commons.collections.PrefetchIterator;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.ResultSetCloseable;
import org.aksw.jena_sparql_api.utils.CloseableQueryExecution;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIteratorResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSetPaginated
extends PrefetchIterator<Binding>
implements Closeable {
    private static Logger logger = LoggerFactory.getLogger(ResultSetPaginated.class);
    private QueryExecutionFactory serviceFactory;
    private Iterator<Query> queryIterator;
    private boolean stopOnEmptyResult = true;
    private ResultSet currentResultSet = null;
    private QueryExecution currentExecution = null;
    private List<String> currentResultVars = null;

    public ResultSetPaginated(QueryExecutionFactory service, Iterator<Query> queryIterator, boolean stopOnEmptyResult) {
        this.serviceFactory = service;
        this.queryIterator = queryIterator;
    }

    public ResultSet getCurrentResultSet() {
        return this.currentResultSet;
    }

    public List<String> getCurrentResultVars() {
        return this.currentResultVars;
    }

    protected QueryIteratorResultSet prefetch() throws Exception {
        while (this.queryIterator.hasNext()) {
            Query query = this.queryIterator.next();
            if (query == null) {
                throw new RuntimeException("Null query encountered in iterator");
            }
            QueryExecution qe = this.serviceFactory.createQueryExecution(query);
            logger.trace("Executing: " + query);
            this.currentResultSet = qe.execSelect();
            this.currentResultVars = this.currentResultSet.getResultVars();
            this.currentResultSet = new ResultSetCloseable(this.currentResultSet, (java.io.Closeable)new CloseableQueryExecution(qe));
            if (!this.currentResultSet.hasNext()) {
                if (!this.stopOnEmptyResult) continue;
                break;
            }
            return new QueryIteratorResultSet(this.currentResultSet);
        }
        return null;
    }

    public void close() {
        if (this.currentExecution != null) {
            this.currentExecution.close();
        }
    }
}

