/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.retry.core;

import com.google.common.util.concurrent.ListenableFuture;
import com.nurkiewicz.asyncretry.AsyncRetryExecutor;
import com.nurkiewicz.asyncretry.backoff.Backoff;
import com.nurkiewicz.asyncretry.policy.AbortRetryException;
import com.nurkiewicz.asyncretry.policy.RetryPolicy;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.aksw.jena_sparql_api.core.QueryExecutionDecorator;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;

public class QueryExecutionRetry
extends QueryExecutionDecorator {
    protected Supplier<QueryExecution> supplier;
    protected int retryCount;
    protected long retryDelayInMs;
    protected RetryPolicy retryPolicy;
    protected Backoff backoff;
    protected boolean fixedDelay;
    protected ScheduledExecutorService scheduler;
    protected boolean aborted = false;

    public QueryExecutionRetry(Supplier<QueryExecution> supplier, int retryCount, long retryDelayInMs, ScheduledExecutorService scheduler) {
        super(null);
        this.supplier = supplier;
        this.retryCount = retryCount;
        this.retryDelayInMs = retryDelayInMs;
        this.scheduler = scheduler;
    }

    public QueryExecutionRetry(Supplier<QueryExecution> supplier, RetryPolicy retryPolicy, Backoff backoff, boolean fixedDelay, ScheduledExecutorService scheduler) {
        super(null);
        this.supplier = supplier;
        this.retryPolicy = retryPolicy;
        this.backoff = backoff;
        this.fixedDelay = fixedDelay;
        this.scheduler = scheduler;
    }

    public <T> T doTry(Callable<T> callable) {
        Callable<Object> wrapper = () -> {
            if (this.decoratee == null) {
                this.decoratee = this.supplier.get();
            }
            try {
                return callable.call();
            }
            catch (Exception e) {
                if (this.aborted) {
                    throw new AbortRetryException();
                }
                this.decoratee = null;
                throw new RuntimeException(e);
            }
        };
        AsyncRetryExecutor executor = new AsyncRetryExecutor(this.scheduler, this.retryPolicy, this.backoff, this.fixedDelay);
        ListenableFuture future = executor.getWithRetry(wrapper);
        try {
            Object result;
            Object object = result = future.get();
            return (T)object;
        }
        catch (Exception e) {
            throw new RuntimeException("Query Execution failed, even with retries.", e);
        }
        finally {
            this.scheduler.shutdown();
        }
    }

    @Override
    public void abort() {
        this.aborted = true;
        if (this.decoratee != null) {
            this.decoratee.abort();
        }
    }

    @Override
    public boolean execAsk() {
        return this.doTry(() -> super.execAsk());
    }

    @Override
    public ResultSet execSelect() {
        return this.doTry(() -> super.execSelect());
    }

    @Override
    public Model execConstruct() {
        return this.doTry(() -> super.execConstruct());
    }

    @Override
    public Model execConstruct(Model model) {
        return this.doTry(() -> super.execConstruct(model));
    }

    @Override
    public Iterator<Triple> execConstructTriples() {
        return this.doTry(() -> super.execConstructTriples());
    }

    @Override
    public Model execDescribe() {
        return this.doTry(() -> super.execDescribe());
    }

    @Override
    public Model execDescribe(Model model) {
        return this.doTry(() -> super.execDescribe(model));
    }

    @Override
    public Iterator<Triple> execDescribeTriples() {
        return this.doTry(() -> super.execDescribeTriples());
    }
}

