/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.stmt;

import com.google.common.base.Supplier;
import org.aksw.jena_sparql_api.stmt.QuerySupplierImpl;
import org.aksw.jena_sparql_api.stmt.SparqlParserConfig;
import org.aksw.jena_sparql_api.stmt.SparqlQueryParser;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.Prologue;

public class SparqlQueryParserImpl
implements SparqlQueryParser {
    protected Supplier<Query> querySupplier;
    protected Syntax syntax;
    protected String baseURI;

    public SparqlQueryParserImpl() {
        this(new QuerySupplierImpl(), Syntax.syntaxARQ, "http://example.org/base/");
    }

    public SparqlQueryParserImpl(Supplier<Query> querySupplier, Syntax syntax, String baseURI) {
        this.querySupplier = querySupplier;
        this.syntax = syntax;
        this.baseURI = baseURI;
    }

    @Override
    public Query apply(String queryString) {
        Query result = (Query)this.querySupplier.get();
        QueryFactory.parse((Query)result, (String)queryString, (String)this.baseURI, (Syntax)this.syntax);
        return result;
    }

    public static SparqlQueryParserImpl create(SparqlParserConfig config) {
        SparqlQueryParserImpl result = SparqlQueryParserImpl.create(config.getSyntax(), config.getPrologue());
        return result;
    }

    public static SparqlQueryParserImpl create() {
        SparqlQueryParserImpl result = SparqlQueryParserImpl.create(Syntax.syntaxARQ, null);
        return result;
    }

    public static SparqlQueryParserImpl create(Syntax syntax) {
        SparqlQueryParserImpl result = SparqlQueryParserImpl.create(syntax, null);
        return result;
    }

    public static SparqlQueryParserImpl create(Syntax syntax, Prologue prologue) {
        QuerySupplierImpl querySupplier = new QuerySupplierImpl(prologue);
        SparqlQueryParserImpl result = new SparqlQueryParserImpl(querySupplier, syntax, null);
        return result;
    }
}

