/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.stmt;

import org.aksw.jena_sparql_api.stmt.SparqlStmt;
import org.aksw.jena_sparql_api.stmt.SparqlStmtQuery;
import org.aksw.jena_sparql_api.stmt.SparqlStmtUpdate;
import org.apache.jena.query.QueryParseException;

public abstract class SparqlStmtBase
implements SparqlStmt {
    protected String originalString;
    protected QueryParseException parseException;

    public SparqlStmtBase(String originalString) {
        this(originalString, null);
    }

    public SparqlStmtBase(String originalString, QueryParseException parseException) {
        this.originalString = originalString;
        this.parseException = parseException;
    }

    @Override
    public String getOriginalString() {
        return this.originalString;
    }

    @Override
    public QueryParseException getParseException() {
        return this.parseException;
    }

    @Override
    public boolean isQuery() {
        return false;
    }

    @Override
    public boolean isUpdateRequest() {
        return false;
    }

    @Override
    public SparqlStmtUpdate getAsUpdateStmt() {
        throw new RuntimeException("Invalid type");
    }

    @Override
    public SparqlStmtQuery getAsQueryStmt() {
        throw new RuntimeException("Invalid type");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.originalString == null ? 0 : this.originalString.hashCode());
        result = 31 * result + (this.parseException == null ? 0 : ((Object)((Object)this.parseException)).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparqlStmtBase other = (SparqlStmtBase)obj;
        if (this.originalString == null ? other.originalString != null : !this.originalString.equals(other.originalString)) {
            return false;
        }
        return !(this.parseException == null ? other.parseException != null : !((Object)((Object)this.parseException)).equals((Object)other.parseException));
    }

    public String toString() {
        return "SparqlStmtBase [originalString=" + this.originalString + ", parseException=" + (Object)((Object)this.parseException) + "]";
    }
}

