/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.stmt;

import org.aksw.jena_sparql_api.stmt.QueryParseExceptionComparator;
import org.aksw.jena_sparql_api.stmt.SparqlParserConfig;
import org.aksw.jena_sparql_api.stmt.SparqlQueryParser;
import org.aksw.jena_sparql_api.stmt.SparqlQueryParserImpl;
import org.aksw.jena_sparql_api.stmt.SparqlStmt;
import org.aksw.jena_sparql_api.stmt.SparqlStmtBase;
import org.aksw.jena_sparql_api.stmt.SparqlStmtParser;
import org.aksw.jena_sparql_api.stmt.SparqlStmtQuery;
import org.aksw.jena_sparql_api.stmt.SparqlStmtUpdate;
import org.aksw.jena_sparql_api.stmt.SparqlUpdateParser;
import org.aksw.jena_sparql_api.stmt.SparqlUpdateParserImpl;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryParseException;
import org.apache.jena.query.Syntax;
import org.apache.jena.update.UpdateRequest;

public class SparqlStmtParserImpl
implements SparqlStmtParser {
    protected SparqlQueryParser queryParser;
    protected SparqlUpdateParser updateParser;
    protected boolean actAsClassifier;

    public SparqlStmtParserImpl(SparqlQueryParser queryParser, SparqlUpdateParser updateParser) {
        this(queryParser, updateParser, false);
    }

    public SparqlStmtParserImpl(SparqlQueryParser queryParser, SparqlUpdateParser updateParser, boolean actAsClassifier) {
        this.queryParser = queryParser;
        this.updateParser = updateParser;
        this.actAsClassifier = actAsClassifier;
    }

    public SparqlQueryParser getQueryParser() {
        return this.queryParser;
    }

    public SparqlUpdateParser getUpdateParser() {
        return this.updateParser;
    }

    public boolean isActAsClassifier() {
        return this.actAsClassifier;
    }

    @Override
    public SparqlStmt apply(String stmtStr) {
        SparqlStmtBase result;
        block7: {
            try {
                Query query = (Query)this.queryParser.apply(stmtStr);
                result = new SparqlStmtQuery(query);
            }
            catch (QueryParseException queryException) {
                try {
                    UpdateRequest updateRequest = (UpdateRequest)this.updateParser.apply(stmtStr);
                    result = new SparqlStmtUpdate(updateRequest);
                }
                catch (QueryParseException updateException) {
                    boolean isQueryException;
                    int delta = QueryParseExceptionComparator.doCompare(queryException, updateException);
                    boolean bl = isQueryException = delta <= 0;
                    if (isQueryException) {
                        if (this.actAsClassifier) {
                            result = new SparqlStmtQuery(stmtStr, queryException);
                            break block7;
                        }
                        throw new RuntimeException("Failed to parse " + stmtStr, queryException);
                    }
                    if (this.actAsClassifier) {
                        result = new SparqlStmtUpdate(stmtStr, updateException);
                        break block7;
                    }
                    throw new RuntimeException("Failed to parse " + stmtStr, updateException);
                }
            }
        }
        return result;
    }

    public static SparqlStmtParserImpl create(Syntax syntax, boolean actAsClassifier) {
        SparqlStmtParserImpl result = SparqlStmtParserImpl.create(SparqlParserConfig.create(syntax), actAsClassifier);
        return result;
    }

    public static SparqlStmtParserImpl create(SparqlParserConfig config) {
        SparqlStmtParserImpl result = SparqlStmtParserImpl.create(config, false);
        return result;
    }

    public static SparqlStmtParserImpl create(SparqlParserConfig config, boolean actAsClassifier) {
        SparqlQueryParserImpl queryParser = SparqlQueryParserImpl.create(config);
        SparqlUpdateParserImpl updateParser = SparqlUpdateParserImpl.create(config);
        SparqlStmtParserImpl result = new SparqlStmtParserImpl(queryParser, updateParser, actAsClassifier);
        return result;
    }
}

