/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.stmt;

import com.google.common.base.Supplier;
import org.aksw.jena_sparql_api.stmt.SparqlParserConfig;
import org.aksw.jena_sparql_api.stmt.SparqlUpdateParser;
import org.aksw.jena_sparql_api.stmt.UpdateSupplierImpl;
import org.apache.jena.query.Syntax;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;

public class SparqlUpdateParserImpl
implements SparqlUpdateParser {
    protected Supplier<UpdateRequest> updateRequestSupplier;
    protected Syntax syntax;
    protected String baseURI;

    public SparqlUpdateParserImpl(Supplier<UpdateRequest> updateRequestSupplier, Syntax syntax, String baseURI) {
        this.updateRequestSupplier = updateRequestSupplier;
        this.syntax = syntax;
        this.baseURI = baseURI;
    }

    @Override
    public UpdateRequest apply(String updateString) {
        UpdateRequest result = (UpdateRequest)this.updateRequestSupplier.get();
        UpdateFactory.parse((UpdateRequest)result, (String)updateString, (String)this.baseURI, (Syntax)this.syntax);
        return result;
    }

    public static SparqlUpdateParserImpl create(SparqlParserConfig config) {
        SparqlUpdateParserImpl result = SparqlUpdateParserImpl.create(config.getSyntax(), config.getPrologue());
        return result;
    }

    public static SparqlUpdateParserImpl create() {
        SparqlUpdateParserImpl result = SparqlUpdateParserImpl.create(Syntax.syntaxARQ);
        return result;
    }

    public static SparqlUpdateParserImpl create(Syntax syntax) {
        Prologue prologue = new Prologue();
        prologue.setBaseURI(IRIResolver.createNoResolve());
        SparqlUpdateParserImpl result = SparqlUpdateParserImpl.create(syntax, prologue);
        return result;
    }

    public static SparqlUpdateParserImpl create(Syntax syntax, Prologue prologue) {
        UpdateSupplierImpl updateSupplier = new UpdateSupplierImpl(prologue);
        SparqlUpdateParserImpl result = new SparqlUpdateParserImpl(updateSupplier, syntax, null);
        return result;
    }
}

