/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.stmt;

import java.util.function.Function;
import org.aksw.jena_sparql_api.stmt.SparqlStmt;
import org.aksw.jena_sparql_api.stmt.SparqlUpdateParser;
import org.apache.jena.update.UpdateRequest;

public class SparqlUpdateParserStmt
implements SparqlUpdateParser {
    protected Function<String, SparqlStmt> stmtParser;

    public SparqlUpdateParserStmt(Function<String, SparqlStmt> stmtParser) {
        this.stmtParser = stmtParser;
    }

    @Override
    public UpdateRequest apply(String queryStr) {
        SparqlStmt stmt = this.stmtParser.apply(queryStr);
        if (!stmt.isUpdateRequest()) {
            throw new RuntimeException("SPARQL statement is not a query: " + stmt);
        }
        UpdateRequest result = stmt.getAsUpdateStmt().getUpdateRequest();
        return result;
    }

    public static SparqlUpdateParserStmt wrap(Function<String, SparqlStmt> stmtParser) {
        SparqlUpdateParserStmt result = new SparqlUpdateParserStmt(stmtParser);
        return result;
    }
}

