/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.transform;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.concepts.Relation;
import org.aksw.jena_sparql_api.utils.ElementUtils;
import org.aksw.jena_sparql_api.utils.Generator;
import org.aksw.jena_sparql_api.utils.VarGeneratorImpl2;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.PathBlock;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformCopyBase;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementTransformVirtualPredicates
extends ElementTransformCopyBase {
    private static final Logger logger = LoggerFactory.getLogger(ElementTransformVirtualPredicates.class);
    protected Map<Node, Relation> virtualPredicates;
    protected Generator<Var> varGen;

    public ElementTransformVirtualPredicates() {
        this(new HashMap<Node, Relation>());
    }

    public ElementTransformVirtualPredicates(Map<Node, Relation> virtualPredicates) {
        this(virtualPredicates, (Generator<Var>)VarGeneratorImpl2.create((String)"v"));
    }

    public ElementTransformVirtualPredicates(Map<Node, Relation> virtualPredicates, Generator<Var> varGen) {
        this.virtualPredicates = virtualPredicates;
        this.varGen = varGen;
    }

    public Element transform(ElementTriplesBlock el) {
        Element result = ElementTransformVirtualPredicates.applyTransform(el, this.virtualPredicates, this.varGen);
        return result;
    }

    public Element transform(ElementPathBlock el) {
        Element result = ElementTransformVirtualPredicates.applyTransform(el, this.virtualPredicates, this.varGen);
        return result;
    }

    public static Element applyTransform(ElementTriplesBlock el, Map<Node, Relation> virtualPredicates, Generator<Var> rootVarGen) {
        BasicPattern bgp = el.getPattern();
        BasicPattern newPattern = new BasicPattern();
        ArrayList<Element> elements = new ArrayList<Element>(bgp.size());
        for (Triple triple : bgp) {
            Generator varGen;
            Element e = ElementTransformVirtualPredicates.applyTransform(triple, virtualPredicates, (Generator<Var>)(varGen = rootVarGen.clone()));
            if (e == null) {
                newPattern.add(triple);
                continue;
            }
            elements.add(e);
        }
        ArrayList<Element> items = newPattern.isEmpty() ? elements : Iterables.concat(Collections.singleton(new ElementTriplesBlock(newPattern)), elements);
        ElementGroup result = ElementUtils.createElementGroup(items);
        return result;
    }

    public static Element applyTransform(ElementPathBlock el, Map<Node, Relation> virtualPredicates, Generator<Var> rootVarGen) {
        PathBlock bgp = el.getPattern();
        ElementPathBlock newPattern = new ElementPathBlock();
        ArrayList<Element> elements = new ArrayList<Element>(bgp.size());
        for (TriplePath tp : bgp) {
            if (tp.isTriple()) {
                Generator varGen;
                Triple triple = tp.asTriple();
                Element e = ElementTransformVirtualPredicates.applyTransform(triple, virtualPredicates, (Generator<Var>)(varGen = rootVarGen.clone()));
                if (e == null) {
                    newPattern.addTriple(new TriplePath(triple));
                    continue;
                }
                elements.add(e);
                continue;
            }
            logger.warn("Triple path expressions not supported");
            newPattern.addTriple(tp);
        }
        ArrayList<Element> items = newPattern.isEmpty() ? elements : Iterables.concat(Collections.singleton(newPattern), elements);
        ElementGroup result = ElementUtils.createElementGroup(items);
        return result;
    }

    public static Element applyTransform(Triple triple, Map<Node, Relation> virtualPredicates, Generator<Var> varGen) {
        Node p = triple.getPredicate();
        Node s = triple.getSubject();
        Node o = triple.getObject();
        Var pVar = p.isVariable() ? (Var)p : null;
        Element result = null;
        if (p.isConcrete()) {
            Relation relation = virtualPredicates.get(p);
            if (relation != null) {
                result = ElementTransformVirtualPredicates.createElementForConcretePredicate(pVar, p, s, o, relation, varGen);
            }
        } else {
            result = ElementTransformVirtualPredicates.createElementForVariablePredicate(pVar, s, o, virtualPredicates, varGen);
        }
        return result;
    }

    public static Element createElementForVariablePredicate(Var pVar, Node s, Node o, Map<Node, Relation> virtualPredicates, Generator<Var> varGen) {
        Triple orig = new Triple(s, (Node)pVar, o);
        ElementUtils.createElement((Triple)orig);
        ArrayList<Object> unionMembers = new ArrayList<Object>();
        unionMembers.add(ElementUtils.createElement((Triple)new Triple(s, (Node)pVar, o)));
        for (Map.Entry<Node, Relation> entry : virtualPredicates.entrySet()) {
            Node pRef = entry.getKey();
            Relation relation = entry.getValue();
            Element e = ElementTransformVirtualPredicates.createElementForConcretePredicate(pVar, pRef, s, o, relation, varGen);
            unionMembers.add(e);
        }
        Element result = ElementUtils.union(unionMembers);
        return result;
    }

    public static Element createElementForConcretePredicate(Var pVar, Node pRef, Node s, Node o, Relation relation, Generator<Var> varGen) {
        Var sourceVar = relation.getSourceVar();
        Var targetVar = relation.getTargetVar();
        ElementBind bind = pVar == null ? null : new ElementBind(pVar, (Expr)NodeValue.makeNode((Node)pRef));
        Set<Var> vars = relation.getVarsMentioned();
        HashMap<Var, Object> nodeMap = new HashMap<Var, Object>();
        List<Var> skip = Arrays.asList(sourceVar, targetVar);
        for (Var var : vars) {
            if (skip.contains(var)) continue;
            Var freshVar = (Var)varGen.next();
            nodeMap.put(var, freshVar);
        }
        nodeMap.put(sourceVar, s);
        nodeMap.put(targetVar, o);
        Element fragment = ElementUtils.createRenamedElement((Element)relation.getElement(), nodeMap);
        Element result = ElementUtils.groupIfNeeded((Element[])new Element[]{fragment, bind});
        return result;
    }

    public static Query transform(Query query, Map<Node, Relation> virtualPredicates, boolean cloneOnChange) {
        Query result;
        Element newQueryPattern;
        Element oldQueryPattern = query.getQueryPattern();
        if (oldQueryPattern == (newQueryPattern = ElementTransformVirtualPredicates.transform(oldQueryPattern, virtualPredicates))) {
            result = query;
        } else {
            result = cloneOnChange ? query.cloneQuery() : query;
            result.setQueryPattern(newQueryPattern);
        }
        return result;
    }

    public static Element transform(Element element, Map<Node, Relation> virtualPredicates) {
        ElementTransformVirtualPredicates elementTransform = new ElementTransformVirtualPredicates(virtualPredicates);
        Element result = ElementTransformer.transform((Element)element, (ElementTransform)elementTransform, (ExprTransform)new ExprTransformCopy(false));
        return result;
    }
}

