/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.update;

import org.aksw.jena_sparql_api.core.UpdateExecutionFactory;
import org.aksw.jena_sparql_api.core.UpdateExecutionFactoryDataset;
import org.aksw.jena_sparql_api.core.UpdateExecutionFactoryHttp;
import org.aksw.jena_sparql_api.core.UpdateExecutionFactoryModel;
import org.apache.http.client.HttpClient;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.util.Context;

public class FluentUpdateExecutionFactory {
    private UpdateExecutionFactory uef;

    public FluentUpdateExecutionFactory(UpdateExecutionFactory uef) {
        this.uef = uef;
    }

    public UpdateExecutionFactory create() {
        return this.uef;
    }

    public static FluentUpdateExecutionFactory from(UpdateExecutionFactory uef) {
        FluentUpdateExecutionFactory result = new FluentUpdateExecutionFactory(uef);
        return result;
    }

    public static FluentUpdateExecutionFactory from(Model model) {
        UpdateExecutionFactoryModel uef = new UpdateExecutionFactoryModel(model);
        FluentUpdateExecutionFactory result = FluentUpdateExecutionFactory.from(uef);
        return result;
    }

    public static FluentUpdateExecutionFactory from(Model model, Context context) {
        DatasetGraph datasetGraph = DatasetGraphFactory.create((Graph)model.getGraph());
        FluentUpdateExecutionFactory result = FluentUpdateExecutionFactory.from(datasetGraph, context);
        return result;
    }

    public static FluentUpdateExecutionFactory from(Dataset dataset) {
        FluentUpdateExecutionFactory result = FluentUpdateExecutionFactory.from(dataset, null);
        return result;
    }

    public static FluentUpdateExecutionFactory from(Dataset dataset, Context context) {
        UpdateExecutionFactoryDataset uef = new UpdateExecutionFactoryDataset(dataset, context);
        FluentUpdateExecutionFactory result = FluentUpdateExecutionFactory.from(uef);
        return result;
    }

    public static FluentUpdateExecutionFactory from(DatasetGraph datasetGraph) {
        FluentUpdateExecutionFactory result = FluentUpdateExecutionFactory.from(datasetGraph, null);
        return result;
    }

    public static FluentUpdateExecutionFactory from(DatasetGraph datasetGraph, Context context) {
        Dataset dataset = DatasetImpl.wrap((DatasetGraph)datasetGraph);
        FluentUpdateExecutionFactory result = FluentUpdateExecutionFactory.from(dataset, context);
        return result;
    }

    public static FluentUpdateExecutionFactory http(String endpointUrl, DatasetDescription datasetDescription, HttpClient httpClient) {
        UpdateExecutionFactoryHttp uef = new UpdateExecutionFactoryHttp(endpointUrl, datasetDescription, httpClient);
        FluentUpdateExecutionFactory result = FluentUpdateExecutionFactory.from(uef);
        return result;
    }
}

