/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.update;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Triple;

public abstract class GraphListenerBatchBase
implements GraphListener {
    protected abstract void addEvent(Graph var1, Iterator<Triple> var2);

    protected abstract void deleteEvent(Graph var1, Iterator<Triple> var2);

    public void addEvent(Graph g, Iterable<Triple> items) {
        this.addEvent(g, items.iterator());
    }

    public void deleteEvent(Graph g, Iterable<Triple> items) {
        this.deleteEvent(g, items.iterator());
    }

    public void notifyAddTriple(Graph g, Triple t) {
        this.addEvent(g, Collections.singleton(t));
    }

    public void notifyAddArray(Graph g, Triple[] triples) {
        this.addEvent(g, Arrays.asList(triples));
    }

    public void notifyAddList(Graph g, List<Triple> triples) {
        this.addEvent(g, triples.iterator());
    }

    public void notifyAddIterator(Graph g, Iterator<Triple> it) {
        this.addEvent(g, it);
    }

    public void notifyAddGraph(Graph g, Graph added) {
    }

    public void notifyDeleteTriple(Graph g, Triple t) {
        this.deleteEvent(g, Collections.singleton(t));
    }

    public void notifyDeleteList(Graph g, List<Triple> triples) {
        this.deleteEvent(g, triples.iterator());
    }

    public void notifyDeleteArray(Graph g, Triple[] triples) {
        this.deleteEvent(g, Arrays.asList(triples));
    }

    public void notifyDeleteIterator(Graph g, Iterator<Triple> it) {
        this.deleteEvent(g, it);
    }

    public void notifyDeleteGraph(Graph g, Graph removed) {
    }

    public void notifyEvent(Graph source, Object value) {
    }
}

