/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.update;

import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import java.util.Map;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.util.iterator.ExtendedIterator;

public class IteratorQuadsFromNodeToGraph
extends AbstractIterator<Quad> {
    private Iterator<Map.Entry<Node, Graph>> itGraphs;
    private Map.Entry<Node, Graph> currentEntry;
    private ExtendedIterator<Triple> itTriples;

    public IteratorQuadsFromNodeToGraph(Iterator<Map.Entry<Node, Graph>> itGraphs) {
        this.itGraphs = itGraphs;
    }

    protected Quad computeNext() {
        while (this.itTriples == null || !this.itTriples.hasNext()) {
            if (!this.itGraphs.hasNext()) {
                return (Quad)this.endOfData();
            }
            this.currentEntry = this.itGraphs.next();
            this.itTriples = this.currentEntry.getValue().find(Node.ANY, Node.ANY, Node.ANY);
        }
        Node g = this.currentEntry.getKey();
        Triple triple = (Triple)this.itTriples.next();
        Quad result = new Quad(g, triple);
        return result;
    }

    public static IteratorQuadsFromNodeToGraph create(Map<Node, Graph> nodeToGraph) {
        IteratorQuadsFromNodeToGraph result = new IteratorQuadsFromNodeToGraph(nodeToGraph.entrySet().iterator());
        return result;
    }
}

