/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.update;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.update.Tables;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;

public class QuadContainmentUtils {
    public static Set<Quad> checkContainment(QueryExecutionFactory qef, Iterable<Quad> iterable) {
        Set<Quad> result = QuadContainmentUtils.checkContainment(qef, iterable.iterator());
        return result;
    }

    public static Set<Quad> checkContainment(QueryExecutionFactory qef, Iterator<Quad> it) {
        HashSet<Quad> result = new HashSet<Quad>();
        Query query = QuadContainmentUtils.createQueryCheckExistenceValues(it);
        System.out.println("Containment Check Query: " + query);
        QueryExecution qe = qef.createQueryExecution(query);
        ResultSet rs = qe.execSelect();
        while (rs.hasNext()) {
            Binding binding = rs.nextBinding();
            Node g = binding.get(Vars.g);
            if (g == null) {
                g = Quad.defaultGraphNodeGenerated;
            }
            Node s = binding.get(Vars.s);
            Node p = binding.get(Vars.p);
            Node o = binding.get(Vars.o);
            Quad quad = new Quad(g, s, p, o);
            result.add(quad);
        }
        return result;
    }

    public static ElementData tableToElement(Table table) {
        ElementData result = new ElementData();
        for (Var v : table.getVars()) {
            result.add(v);
        }
        Iterator it = table.rows();
        while (it.hasNext()) {
            Binding binding = (Binding)it.next();
            result.add(binding);
        }
        return result;
    }

    public static Query createQueryCheckExistenceValues(Iterator<Quad> it) {
        Tables tables = QuadContainmentUtils.createTablesForQuads(it);
        boolean useG = !tables.getNamedGraphTable().isEmpty();
        Element element = QuadContainmentUtils.createElement(tables);
        Query result = new Query();
        result.setQuerySelectType();
        if (useG) {
            result.getProject().add(Vars.g);
        }
        result.getProject().add(Vars.s);
        result.getProject().add(Vars.p);
        result.getProject().add(Vars.o);
        result.setQueryPattern(element);
        return result;
    }

    public static Element createElement(Tables tables) {
        Object result;
        Element e2;
        Table defaultGraphTable = tables.getDefaultGraphTable();
        Table namedGraphTable = tables.getNamedGraphTable();
        boolean isDefaultGraph = !defaultGraphTable.isEmpty();
        boolean isNamedGraph = !namedGraphTable.isEmpty();
        Element e1 = isDefaultGraph ? QuadContainmentUtils.createElementDefaultGraph(defaultGraphTable) : null;
        Element element = e2 = isNamedGraph ? QuadContainmentUtils.createElementNamedGraph(namedGraphTable) : null;
        if (e1 != null && e2 != null) {
            ElementUnion tmp = new ElementUnion();
            tmp.addElement(e1);
            tmp.addElement(e2);
            result = tmp;
        } else {
            result = e1 != null ? e1 : (e2 != null ? e2 : null);
        }
        return result;
    }

    public static Element createElementDefaultGraph(Table table) {
        ElementData elData = QuadContainmentUtils.tableToElement(table);
        ElementTriplesBlock elTriples = new ElementTriplesBlock();
        elTriples.addTriple(new Triple((Node)Vars.s, (Node)Vars.p, (Node)Vars.o));
        ElementGroup result = new ElementGroup();
        result.addElement((Element)elData);
        result.addElement((Element)elTriples);
        return result;
    }

    public static Element createElementNamedGraph(Table table) {
        ElementData elData = QuadContainmentUtils.tableToElement(table);
        ElementTriplesBlock elTriples = new ElementTriplesBlock();
        elTriples.addTriple(new Triple((Node)Vars.s, (Node)Vars.p, (Node)Vars.o));
        ElementGroup result = new ElementGroup();
        result.addElement((Element)elData);
        result.addElement((Element)new ElementNamedGraph((Node)Vars.g, (Element)elTriples));
        return result;
    }

    public static void addToTables(Tables tables, Quad quad) {
        Node g = quad.getGraph();
        Table defaultGraphTable = tables.getDefaultGraphTable();
        Table namedGraphTable = tables.getNamedGraphTable();
        if (Quad.defaultGraphNodeGenerated.equals((Object)g)) {
            Triple triple = quad.asTriple();
            BindingHashMap binding = QuadContainmentUtils.createBinding(triple);
            defaultGraphTable.addBinding((Binding)binding);
        } else {
            BindingHashMap binding = QuadContainmentUtils.createBinding(quad);
            namedGraphTable.addBinding((Binding)binding);
        }
    }

    public static void addToTables(Tables tables, Iterator<Quad> it) {
        while (it.hasNext()) {
            Quad quad = it.next();
            QuadContainmentUtils.addToTables(tables, quad);
        }
    }

    public static Tables createTablesForQuads(Iterator<Quad> it) {
        Tables result = new Tables();
        QuadContainmentUtils.addToTables(result, it);
        return result;
    }

    public static BindingHashMap createBinding(Quad q) {
        BindingHashMap result = new BindingHashMap();
        result.add(Vars.g, q.getGraph());
        QuadContainmentUtils.tripleToBinding(q.asTriple(), result);
        return result;
    }

    public static BindingHashMap createBinding(Triple t) {
        BindingHashMap result = new BindingHashMap();
        QuadContainmentUtils.tripleToBinding(t, result);
        return result;
    }

    public static void tripleToBinding(Triple t, BindingHashMap result) {
        result.add(Vars.s, t.getSubject());
        result.add(Vars.p, t.getPredicate());
        result.add(Vars.o, t.getObject());
    }
}

