/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.update;

import java.util.HashSet;
import java.util.Set;
import org.aksw.jena_sparql_api.core.DatasetListener;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.core.SparqlServiceFactory;
import org.aksw.jena_sparql_api.core.SparqlServiceImpl;
import org.aksw.jena_sparql_api.core.UpdateContext;
import org.aksw.jena_sparql_api.update.QuadContainmentCheckerSimple;
import org.aksw.jena_sparql_api.update.UpdateExecutionFactoryEventSource;
import org.apache.http.client.HttpClient;
import org.apache.jena.sparql.core.DatasetDescription;

public class SparqlServiceFactoryEventSource
implements SparqlServiceFactory {
    private SparqlServiceFactory delegate;
    private Set<DatasetListener> datasetListeners = new HashSet<DatasetListener>();

    public SparqlServiceFactoryEventSource(SparqlServiceFactory delegate) {
        this.delegate = delegate;
    }

    public Set<DatasetListener> getListeners() {
        return this.datasetListeners;
    }

    @Override
    public SparqlService createSparqlService(String serviceUri, DatasetDescription datasetDescription, HttpClient httpClient) {
        SparqlService core = this.delegate.createSparqlService(serviceUri, datasetDescription, httpClient);
        UpdateContext updateContext = new UpdateContext(core, 128, new QuadContainmentCheckerSimple());
        UpdateExecutionFactoryEventSource uef = new UpdateExecutionFactoryEventSource(updateContext);
        uef.getDatasetListeners().addAll(this.datasetListeners);
        SparqlServiceImpl result = new SparqlServiceImpl(serviceUri, datasetDescription, core.getQueryExecutionFactory(), uef);
        return result;
    }
}

