/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.update;

import org.aksw.jena_sparql_api.core.QuadContainmentChecker;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.core.UpdateContext;
import org.aksw.jena_sparql_api.update.QuadContainmentCheckerSimple;
import org.aksw.jena_sparql_api.update.UpdateExecutionFactoryEventSource;
import org.aksw.jena_sparql_api.update.UpdateStrategy;

public class UpdateStrategyEventSource
implements UpdateStrategy<UpdateExecutionFactoryEventSource> {
    public static final int defaultBatchSize = 128;
    public static final QuadContainmentChecker defaultQuadContainmentChecker = new QuadContainmentCheckerSimple();
    private Integer batchSize;
    private QuadContainmentChecker containmentChecker;

    public UpdateStrategyEventSource() {
        this(128, defaultQuadContainmentChecker);
    }

    public UpdateStrategyEventSource(Integer batchSize) {
        this(batchSize, defaultQuadContainmentChecker);
    }

    public UpdateStrategyEventSource(QuadContainmentCheckerSimple quadContainmentChecker) {
        this(128, defaultQuadContainmentChecker);
    }

    public UpdateStrategyEventSource(Integer batchSize, QuadContainmentChecker containmentChecker) {
        this.batchSize = batchSize;
        this.containmentChecker = containmentChecker;
    }

    @Override
    public UpdateExecutionFactoryEventSource apply(SparqlService sparqlService) {
        UpdateContext updateContext = new UpdateContext(sparqlService, this.batchSize, this.containmentChecker);
        UpdateExecutionFactoryEventSource result = new UpdateExecutionFactoryEventSource(updateContext);
        return result;
    }
}

