/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.example.views;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.aksw.jena_sparql_api.core.FluentQueryExecutionFactory;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.core.SparqlServiceFactory;
import org.aksw.jena_sparql_api.core.SparqlServiceImpl;
import org.aksw.jena_sparql_api.server.utils.SparqlServerUtils;
import org.aksw.jena_sparql_api.stmt.SparqlQueryParserImpl;
import org.aksw.jena_sparql_api.stmt.SparqlStmtParser;
import org.aksw.jena_sparql_api.stmt.SparqlStmtParserImpl;
import org.aksw.jena_sparql_api.utils.DatasetDescriptionUtils;
import org.aksw.jena_sparql_api.utils.transform.F_QueryTransformDatasetDescription;
import org.aksw.jena_sparql_api.views.CandidateViewSelector;
import org.aksw.jena_sparql_api.views.CandidateViewSelectorSparqlView;
import org.aksw.jena_sparql_api.views.Dialect;
import org.aksw.jena_sparql_api.views.IViewDef;
import org.aksw.jena_sparql_api.views.QueryExecutionFactorySparqlView;
import org.aksw.jena_sparql_api.views.SparqlView;
import org.apache.http.client.HttpClient;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.vocabulary.SKOS;

public class LDQ16Demonstrator
implements AutoCloseable {
    QueryExecutionFactory qef;
    QueryExecutionFactorySparqlView currentSparqlView;
    Map<String, CandidateViewSelector<SparqlView>> sparqlViews = new LinkedHashMap<String, CandidateViewSelector<SparqlView>>();
    Map<String, QueryExecutionFactorySparqlView> sparqlQueryExectionFactoryMap = new LinkedHashMap<String, QueryExecutionFactorySparqlView>();
    static final String purlCreator = "http://purl.org/dc/terms/creator";
    static final String admsIdentifierClass = "http://www.w3.org/ns/adms#Identifier";
    static final String admsIdentifierProperty = "http://www.w3.org/ns/adms#identifier";

    public LDQ16Demonstrator(String sparqlEndpoint, String sourceGraphName) {
        this.qef = (QueryExecutionFactory)((FluentQueryExecutionFactory)FluentQueryExecutionFactory.http((String)sparqlEndpoint, (String[])new String[0]).config().withParser((Function)SparqlQueryParserImpl.create()).withDatasetDescription(DatasetDescriptionUtils.createDefaultGraph((String)sourceGraphName)).withQueryTransform((Function)F_QueryTransformDatasetDescription.fn).withPagination(1000).end()).create();
    }

    public void addView(String layerName, String constructQuery) {
        if (null == layerName || null == constructQuery || !constructQuery.toLowerCase().contains("construct")) {
            return;
        }
        System.out.println("Add view for layer '" + layerName + "': " + constructQuery);
        CandidateViewSelectorSparqlView candidateViewSelector = this.sparqlViews.get(layerName);
        if (null == candidateViewSelector) {
            candidateViewSelector = new CandidateViewSelectorSparqlView();
            this.sparqlViews.put(layerName, (CandidateViewSelector<SparqlView>)candidateViewSelector);
        }
        SparqlView sparqlViewGridId = SparqlView.create((String)(layerName + candidateViewSelector.getViews().size()), (String)constructQuery);
        candidateViewSelector.addView((IViewDef)sparqlViewGridId);
        QueryExecutionFactorySparqlView sparqlViewQueryExectionFactory = this.sparqlQueryExectionFactoryMap.get(layerName);
        if (null == sparqlViewQueryExectionFactory) {
            sparqlViewQueryExectionFactory = null == this.currentSparqlView ? new QueryExecutionFactorySparqlView(this.qef, (CandidateViewSelector)candidateViewSelector, Dialect.VIRTUOSO) : new QueryExecutionFactorySparqlView((QueryExecutionFactory)this.currentSparqlView, (CandidateViewSelector)candidateViewSelector, Dialect.VIRTUOSO);
            this.currentSparqlView = sparqlViewQueryExectionFactory;
            this.sparqlQueryExectionFactoryMap.put(layerName, sparqlViewQueryExectionFactory);
        }
    }

    public void addMixedLayer(String mixedLayerName, List<String> otherLayers, String constructQuery) {
        if (null == mixedLayerName || null == constructQuery) {
            return;
        }
        System.out.println("Added mixed view for '" + otherLayers + "' with query: " + constructQuery);
        CandidateViewSelectorSparqlView candidateViewSelector = this.sparqlViews.get(mixedLayerName);
        if (null == candidateViewSelector) {
            candidateViewSelector = new CandidateViewSelectorSparqlView();
            this.sparqlViews.put(mixedLayerName, (CandidateViewSelector<SparqlView>)candidateViewSelector);
        }
        for (String otherLayer : otherLayers) {
            CandidateViewSelector<SparqlView> viewSelector = this.sparqlViews.get(otherLayer);
            if (null == viewSelector) continue;
            for (SparqlView view : viewSelector.getViews()) {
                candidateViewSelector.addView((IViewDef)view);
            }
        }
        SparqlView sparqlViewBase = SparqlView.create((String)(mixedLayerName + "0"), (String)constructQuery);
        candidateViewSelector.addView((IViewDef)sparqlViewBase);
        QueryExecutionFactorySparqlView sparqlViewQueryExectionFactory = this.sparqlQueryExectionFactoryMap.get(mixedLayerName);
        if (null == sparqlViewQueryExectionFactory) {
            sparqlViewQueryExectionFactory = new QueryExecutionFactorySparqlView(this.qef, (CandidateViewSelector)candidateViewSelector, Dialect.VIRTUOSO);
            this.sparqlQueryExectionFactoryMap.put(mixedLayerName, sparqlViewQueryExectionFactory);
        }
    }

    public QueryExecution executeQuery(String searchQuery) {
        if (null == searchQuery) {
            return null;
        }
        System.out.println("Execute query: \n" + searchQuery);
        return this.currentSparqlView.createQueryExecution(searchQuery);
    }

    public QueryExecution executeQuery(String layerName, String searchQuery) {
        if (null == layerName || null == searchQuery) {
            return null;
        }
        System.out.println("Execute query in layer '" + layerName + "': \n" + searchQuery);
        QueryExecutionFactorySparqlView sparqlViewQueryExectionFactory = this.sparqlQueryExectionFactoryMap.get(layerName);
        if (null == sparqlViewQueryExectionFactory) {
            return null;
        }
        return sparqlViewQueryExectionFactory.createQueryExecution(searchQuery);
    }

    public void startServer(short port) {
        if (0 > port) {
            return;
        }
        SparqlStmtParserImpl sparqlStmtParser = SparqlStmtParserImpl.create((Syntax)Syntax.syntaxARQ, (boolean)true);
        SparqlServiceFactory ssf = new SparqlServiceFactory(){

            public SparqlService createSparqlService(String serviceUri, DatasetDescription datasetDescription, HttpClient httpClient) {
                return new SparqlServiceImpl((QueryExecutionFactory)LDQ16Demonstrator.this.currentSparqlView, null);
            }
        };
        System.out.println("Start Server for top layer on port: " + port);
        SparqlServerUtils.startSparqlEndpoint((SparqlServiceFactory)ssf, (SparqlStmtParser)sparqlStmtParser, (int)port);
    }

    public void startServer(String layerName, short port) {
        if (0 > port || null == layerName || layerName.isEmpty()) {
            return;
        }
        final QueryExecutionFactorySparqlView sparqlView = this.sparqlQueryExectionFactoryMap.get(layerName);
        if (null == sparqlView) {
            return;
        }
        SparqlStmtParserImpl sparqlStmtParser = SparqlStmtParserImpl.create((Syntax)Syntax.syntaxARQ, (boolean)true);
        SparqlServiceFactory ssf = new SparqlServiceFactory(){

            public SparqlService createSparqlService(String serviceUri, DatasetDescription datasetDescription, HttpClient httpClient) {
                return new SparqlServiceImpl((QueryExecutionFactory)sparqlView, null);
            }
        };
        System.out.println("Start Server for '" + layerName + "' on port: " + port);
        SparqlServerUtils.startSparqlEndpoint((SparqlServiceFactory)ssf, (SparqlStmtParser)sparqlStmtParser, (int)port);
    }

    @Override
    public void close() throws Exception {
        if (null != this.sparqlQueryExectionFactoryMap) {
            for (String layerName : this.sparqlQueryExectionFactoryMap.keySet()) {
                QueryExecutionFactorySparqlView queryExecutionFactory = this.sparqlQueryExectionFactoryMap.get(layerName);
                queryExecutionFactory.close();
            }
            this.sparqlQueryExectionFactoryMap.clear();
            this.sparqlQueryExectionFactoryMap = null;
        }
        if (null != this.sparqlViews) {
            this.sparqlViews.clear();
            this.sparqlViews = null;
        }
        if (null != this.qef) {
            this.qef.close();
            this.qef = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InterruptedException {
        LDQ16Demonstrator demo = new LDQ16Demonstrator("http://localhost:9890/sparql", "http://dfki.gcd.source.de");
        try {
            String queryLabelChange = "Construct { ?s <" + SKOS.prefLabel.getURI() + "> ?o } WHERE { ?s <http://grid.source.ac/name> ?o }";
            demo.addView("SourceMappingLayer", queryLabelChange);
            String gridIdQueryChange = "Construct {?s <http://www.w3.org/ns/adms#identifier> ?idInstance . ?idInstance a <http://www.w3.org/ns/adms#Identifier> . ?idInstance <http://purl.org/dc/terms/creator> \"https://grid.ac\" . ?idInstance <" + SKOS.notation.getURI() + "> ?o . } WHERE { ?s <http://grid.source.ac/id> ?o BIND( IRI(CONCAT(STR(?s),\"_gridId\")) AS ?idInstance ) }";
            demo.addView("SourceMappingLayer", gridIdQueryChange);
            String normalizeLabels = "Construct { ?s ?p ?o } WHERE { ?s ?p ?x . Bind(replace(?x, '[aA]', '0') As ?o) }";
            demo.addView("NormalizationLayer", normalizeLabels);
            String mixedLayerQuery = "Construct { ?s ?p ?o . } WHERE { ?s ?p ?o. Filter(?p != <" + SKOS.prefLabel.getURI() + ">)}";
            demo.addMixedLayer("MixedLayer", Arrays.asList("SourceMappingLayer"), mixedLayerQuery);
            boolean useServer = true;
            if (useServer) {
                demo.startServer("SourceMappingLayer", (short)7540);
                demo.startServer((short)7550);
                demo.startServer("MixedLayer", (short)7560);
            }
            QueryExecution queryExecution = demo.executeQuery("SELECT DISTINCT * WHERE { ?s <" + SKOS.prefLabel.getURI() + "> ?o . } LIMIT 10");
            ResultSet resultSet = queryExecution.execSelect();
            if (!useServer) {
                ResultSetFormatter.out((OutputStream)System.out, (ResultSet)resultSet);
            }
            QueryExecution queryExecution2 = demo.executeQuery("SourceMappingLayer", "SELECT ?s ?o WHERE { ?s <" + SKOS.prefLabel.getURI() + "> ?o . } LIMIT 10");
            ResultSet resultSet2 = queryExecution2.execSelect();
            if (!useServer) {
                ResultSetFormatter.out((OutputStream)System.out, (ResultSet)resultSet2);
            }
            if (useServer) {
                char character;
                System.out.println("Press SPACE to exit!");
                while (' ' != (character = (char)System.in.read())) {
                }
                System.out.print("That is all folks");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                demo.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.exit(0);
        }
    }
}

