/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.beans.model;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.beans.model.PropertyOps;

public interface EntityOps {
    public Class<?> getAssociatedClass();

    public <T> T getOps(Class<T> var1);

    public <A> A findAnnotation(Class<A> var1);

    public boolean isInstantiable();

    public Object newInstance();

    public Collection<? extends PropertyOps> getProperties();

    public boolean isClonable();

    public Object clone(Object var1);

    public boolean isPrimitive();

    default public Collection<? extends PropertyOps> getEditableProperties() {
        List result = this.getProperties().stream().filter(p -> p.isReadable() && p.isWritable()).collect(Collectors.toList());
        return result;
    }

    public PropertyOps getProperty(String var1);

    default public Set<String> getPropertyNames() {
        Set<String> result = this.getProperties().stream().map(p -> p.getName()).collect(Collectors.toSet());
        return result;
    }

    public static Object deepCopy(Object entity, Function<Class<?>, EntityOps> classToOps) {
        IdentityHashMap map = new IdentityHashMap();
        Object result = EntityOps.deepCopy(entity, classToOps, map::get, map::put);
        return result;
    }

    public boolean isCollection();

    public Iterator<?> getItems(Object var1);

    public void setItems(Object var1, Iterator<?> var2);

    public static Object deepCopy(Object entity, Function<Class<?>, EntityOps> classToOps, Set<Object> managedEntities) {
        IdentityHashMap map = new IdentityHashMap();
        Object result = EntityOps.deepCopy(entity, classToOps, k -> managedEntities.contains(k) ? k : map.get(k), (k, v) -> {
            map.put(k, v);
            managedEntities.add(v);
        });
        return result;
    }

    public static Object deepCopy(Object entity, Function<Class<?>, EntityOps> classToOps, Function<Object, Object> getEntityToClone, BiConsumer<Object, Object> putEntityToClone) {
        Set isCopied = Sets.newIdentityHashSet();
        Object result = EntityOps.deepCopy(entity, classToOps, getEntityToClone, putEntityToClone, isCopied::contains, isCopied::add);
        return result;
    }

    public static Object deepCopy(Object entity, Function<Class<?>, EntityOps> classToOps, Function<Object, Object> getEntityToClone, BiConsumer<Object, Object> putEntityToClone, Predicate<Object> getIsCopied, Consumer<Object> setIsCopied) {
        Object result;
        if (entity == null) {
            result = null;
        } else {
            boolean needsCopy;
            Class<?> entityClass = entity.getClass();
            EntityOps entityOps = classToOps.apply(entityClass);
            result = getEntityToClone.apply(entity);
            if (result == null) {
                result = entityOps.isPrimitive() ? entityOps.clone(entity) : entityOps.newInstance();
                if (result == null) {
                    throw new RuntimeException("Could not obtain a clone for " + entity.getClass().getName() + ": " + entity);
                }
                putEntityToClone.accept(entity, result);
            }
            boolean bl = needsCopy = result != entity && (result == null || !getIsCopied.test(entity));
            if (needsCopy) {
                setIsCopied.accept(entity);
                for (PropertyOps propertyOps : entityOps.getEditableProperties()) {
                    Object val = propertyOps.getValue(entity);
                    Object newVal = EntityOps.deepCopy(val, classToOps, getEntityToClone, putEntityToClone, getIsCopied, setIsCopied);
                    System.out.println("Setting " + result + "." + propertyOps.getName() + " := " + newVal);
                    propertyOps.setValue(result, newVal);
                }
                if (entityOps.isCollection()) {
                    Iterator<?> it = entityOps.getItems(entity);
                    entityOps.setItems(result, it);
                }
            }
        }
        return result;
    }

    public static void copy(EntityOps sourceOps, EntityOps targetOps, Object fromEntity, Object toEntity) {
        for (PropertyOps propertyOps : targetOps.getProperties()) {
            String name = propertyOps.getName();
            PropertyOps fromOps = sourceOps.getProperty(name);
            Object value = fromOps.getValue(fromEntity);
            propertyOps.setValue(toEntity, value);
        }
    }
}

