/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.beans.model;

import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.aksw.jena_sparql_api.beans.model.PropertyOps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;

public class PropertyModel
implements PropertyOps {
    private static final Logger logger = LoggerFactory.getLogger(PropertyModel.class);
    protected String name;
    protected Class<?> type;
    protected Function<Object, ?> getter;
    protected BiConsumer<Object, Object> setter;
    protected Function<Class<?>, Object> annotationFinder;
    protected Method readMethod;
    protected Method writeMethod;
    protected ConversionService conversionService;

    public PropertyModel() {
    }

    public PropertyModel(String name, Class<?> clazz, Function<Object, ?> getter, BiConsumer<Object, Object> setter, ConversionService conversionService, Function<Class<?>, Object> annotationFinder) {
        this.name = name;
        this.type = clazz;
        this.getter = getter;
        this.setter = setter;
        this.conversionService = conversionService;
        this.annotationFinder = annotationFinder;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public Function<Object, ?> getGetter() {
        return this.getter;
    }

    public void setGetter(Function<Object, ?> getter) {
        this.getter = getter;
    }

    public BiConsumer<Object, ?> getSetter() {
        return this.setter;
    }

    public void setSetter(BiConsumer<Object, Object> setter) {
        this.setter = setter;
    }

    @Override
    public Object getValue(Object entity) {
        Object result = this.getter.apply(entity);
        return result;
    }

    @Override
    public void setValue(Object entity, Object value) {
        boolean canConvert;
        Class<?> valueClass;
        if (value != null && !this.type.equals(valueClass = value.getClass()) && this.conversionService != null && (canConvert = this.conversionService.canConvert(valueClass, this.type))) {
            value = this.conversionService.convert(value, this.type);
        }
        this.setter.accept(entity, value);
    }

    public String toString() {
        return "PropertyModel [name=" + this.name + ", getter=" + this.getter + ", setter=" + this.setter + "]";
    }

    @Override
    public boolean isWritable() {
        boolean result = this.setter != null;
        return result;
    }

    @Override
    public boolean isReadable() {
        boolean result = this.getter != null;
        return result;
    }

    @Override
    public Method getReadMethod() {
        return this.readMethod;
    }

    public void setReadMethod(Method readMethod) {
        this.readMethod = readMethod;
    }

    @Override
    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public void setWriteMethod(Method writeMethod) {
        this.writeMethod = writeMethod;
    }

    @Override
    public <A> A findAnnotation(Class<A> annotationClass) {
        Object tmp;
        Object result = tmp = this.annotationFinder.apply(annotationClass);
        return (A)result;
    }

    public Function<Class<?>, Object> getAnnotationFinder() {
        return this.annotationFinder;
    }

    public void setAnnotationFinder(Function<Class<?>, Object> annotationFinder) {
        this.annotationFinder = annotationFinder;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }
}

