/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.context;

import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.aksw.jena_sparql_api.beans.model.PropertyOps;
import org.aksw.jena_sparql_api.mapper.context.EntityId;
import org.aksw.jena_sparql_api.mapper.context.RdfPersistenceContext;
import org.aksw.jena_sparql_api.mapper.context.ResolutionRequest;
import org.aksw.jena_sparql_api.mapper.impl.engine.EntityGraphMap;
import org.aksw.jena_sparql_api.mapper.model.RdfTypeFactory;
import org.apache.jena.ext.com.google.common.collect.Sets;
import org.apache.jena.graph.Node;

public class RdfPersistenceContextImpl
implements RdfPersistenceContext {
    protected Set<Object> managedEntities = Sets.newIdentityHashSet();
    protected RdfTypeFactory typeFactory;
    protected Map<Object, Node> entityToPrimaryNode = new IdentityHashMap<Object, Node>();
    protected Map<Node, ClassToInstanceMap<Object>> nodeToTypeToEntity = new HashMap<Node, ClassToInstanceMap<Object>>();
    protected List<ResolutionRequest> resolutionRequests = new ArrayList<ResolutionRequest>();
    protected Map<EntityId, Object> idToEntity = new HashMap<EntityId, Object>();
    protected Map<Object, EntityId> entityToId = new IdentityHashMap<Object, EntityId>();
    protected EntityGraphMap<EntityId> entityGraphMap = new EntityGraphMap();

    @Override
    public Map<Object, Node> getPrimaryNodeMap() {
        return this.entityToPrimaryNode;
    }

    @Override
    public List<ResolutionRequest> getResolutionRequests() {
        return this.resolutionRequests;
    }

    @Override
    public Set<Object> getManagedEntities() {
        return this.managedEntities;
    }

    @Override
    public void requestResolution(PropertyOps propertyOps, Object entity, Node node) {
        ResolutionRequest request = new ResolutionRequest(propertyOps, entity, node, null);
        this.resolutionRequests.add(request);
    }

    @Override
    public Object entityFor(Class<?> clazz, Node node, Supplier<Object> newInstance) {
        ClassToInstanceMap typeToEntity = this.nodeToTypeToEntity.computeIfAbsent(node, x -> MutableClassToInstanceMap.create());
        Object result = newInstance != null ? typeToEntity.computeIfAbsent(clazz, type -> newInstance.get()) : typeToEntity.get(clazz);
        return result;
    }

    @Override
    public EntityGraphMap<EntityId> getEntityGraphMap() {
        return this.entityGraphMap;
    }

    @Override
    public Map<EntityId, Object> getIdToEntityMap() {
        return this.idToEntity;
    }

    @Override
    public Map<Object, EntityId> getEntityToIdMap() {
        return this.entityToId;
    }
}

