/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.impl.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.jena_sparql_api.beans.model.EntityOps;
import org.aksw.jena_sparql_api.beans.model.PropertyOps;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.core.UpdateExecutionFactory;
import org.aksw.jena_sparql_api.core.utils.ServiceUtils;
import org.aksw.jena_sparql_api.core.utils.UpdateDiffUtils;
import org.aksw.jena_sparql_api.core.utils.UpdateExecutionUtils;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.aksw.jena_sparql_api.lookup.LookupServiceUtils;
import org.aksw.jena_sparql_api.mapper.MappedConcept;
import org.aksw.jena_sparql_api.mapper.context.EntityId;
import org.aksw.jena_sparql_api.mapper.context.RdfEmitterContextImpl;
import org.aksw.jena_sparql_api.mapper.context.RdfPersistenceContext;
import org.aksw.jena_sparql_api.mapper.context.RdfPersistenceContextImpl;
import org.aksw.jena_sparql_api.mapper.context.ResolutionRequest;
import org.aksw.jena_sparql_api.mapper.impl.engine.EntityGraphMap;
import org.aksw.jena_sparql_api.mapper.impl.engine.RdfMapperEngine;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeFactoryImpl;
import org.aksw.jena_sparql_api.mapper.model.RdfPopulatorProperty;
import org.aksw.jena_sparql_api.mapper.model.RdfType;
import org.aksw.jena_sparql_api.mapper.model.RdfTypeFactory;
import org.aksw.jena_sparql_api.shape.ResourceShape;
import org.aksw.jena_sparql_api.shape.ResourceShapeBuilder;
import org.aksw.jena_sparql_api.utils.DatasetDescriptionUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.GraphFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfMapperEngineImpl
implements RdfMapperEngine {
    private static final Logger logger = LoggerFactory.getLogger(RdfMapperEngine.class);
    protected Prologue prologue;
    protected SparqlService sparqlService;
    protected RdfTypeFactory typeFactory;
    protected RdfPersistenceContext persistenceContext;

    public RdfMapperEngineImpl(SparqlService sparqlService) {
        this(sparqlService, RdfTypeFactoryImpl.createDefault(), new Prologue(), null);
    }

    public RdfMapperEngineImpl(SparqlService sparqlService, RdfTypeFactory typeFactory) {
        this(sparqlService, typeFactory, new Prologue(), null);
    }

    public RdfMapperEngineImpl(SparqlService sparqlService, RdfTypeFactory typeFactory, Prologue prologue) {
        this(sparqlService, typeFactory, prologue, null);
    }

    public RdfMapperEngineImpl(SparqlService sparqlService, RdfTypeFactory typeFactory, Prologue prologue, RdfPersistenceContext persistenceContext) {
        this.sparqlService = sparqlService;
        this.typeFactory = typeFactory;
        this.prologue = prologue;
        this.persistenceContext = new RdfPersistenceContextImpl();
    }

    public RdfPersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public Prologue getPrologue() {
        return this.prologue;
    }

    public <T> LookupService<Node, T> getLookupService(Class<T> clazz) {
        return null;
    }

    @Override
    public <T> List<T> list(Class<T> clazz, Concept filterConcept) {
        QueryExecutionFactory qef = this.sparqlService.getQueryExecutionFactory();
        List nodes = ServiceUtils.fetchList((QueryExecutionFactory)qef, (Concept)filterConcept);
        List<T> result = this.list(clazz, nodes);
        return result;
    }

    public <T> List<T> list(Class<T> clazz, List<Node> nodes) {
        ArrayList<T> result = new ArrayList<T>(nodes.size());
        for (Node node : nodes) {
            T entity = this.find(clazz, node);
            result.add(entity);
        }
        return result;
    }

    public Graph fetch(RdfType type, Node node) {
        Graph result;
        ResourceShapeBuilder builder = new ResourceShapeBuilder(this.prologue);
        type.exposeShape(builder);
        ResourceShape shape = builder.getResourceShape();
        if (!shape.isEmpty()) {
            MappedConcept mc = ResourceShape.createMappedConcept((ResourceShape)shape, null, (boolean)false);
            QueryExecutionFactory qef = this.sparqlService.getQueryExecutionFactory();
            LookupService ls = LookupServiceUtils.createLookupService((QueryExecutionFactory)qef, (MappedConcept)mc);
            Map map = (Map)ls.apply(Collections.singleton(node));
            result = (Graph)map.get(node);
        } else {
            result = null;
        }
        if (result == null) {
            result = GraphFactory.createDefaultGraph();
        }
        return result;
    }

    @Override
    public <T> T find(Class<T> clazz, Node node) {
        EntityId entityId = new EntityId(clazz, node);
        logger.debug("Entity lookup with " + node + " " + clazz.getName());
        System.out.println("Entity lookup with " + node + " " + clazz.getName());
        Object entity = this.persistenceContext.entityFor(clazz, node, null);
        if (entity == null) {
            RdfType type = this.typeFactory.forJavaType(clazz);
            Graph graph = this.fetch(type, node);
            entity = type.createJavaObject(node, graph);
            Graph refGraph = GraphFactory.createDefaultGraph();
            type.populateEntity(this.persistenceContext, entity, node, graph, arg_0 -> ((Graph)refGraph).add(arg_0));
            EntityGraphMap<EntityId> entityGraphMap = this.persistenceContext.getEntityGraphMap();
            entityGraphMap.putAll(refGraph, entityId);
            this.persistenceContext.getIdToEntityMap().put(entityId, entity);
            this.persistenceContext.getEntityToIdMap().put(entity, entityId);
        }
        List<ResolutionRequest> requests = this.persistenceContext.getResolutionRequests();
        while (!requests.isEmpty()) {
            Class<?> resolveClass;
            Iterator<ResolutionRequest> it = requests.iterator();
            ResolutionRequest request = it.next();
            it.remove();
            Object resolveEntity = request.getEntity();
            PropertyOps resolveProperty = request.getPropertyOps();
            Object resolveValue = resolveProperty.getValue(resolveEntity);
            Node resolveNode = request.getNode();
            RdfType resolveRdfClass = request.getType();
            Object object = resolveRdfClass == null ? (resolveValue == null ? null : resolveValue.getClass()) : (resolveClass = resolveRdfClass.getEntityClass());
            if (resolveNode == null) {
                Class<?> resolveEntityClass = resolveEntity.getClass();
                RdfType resolveEntityRdfType = this.typeFactory.forJavaType(resolveEntityClass);
                resolveNode = resolveEntityRdfType.getRootNode(resolveEntity);
                if (resolveClass == null) {
                    resolveClass = resolveEntityClass;
                }
                System.out.println("oops");
            }
            if (resolveClass == null || resolveNode == null) {
                throw new RuntimeException("Should not happen");
            }
            Object childEntity = this.find(resolveClass, resolveNode);
            PropertyOps childPropertyOps = request.getPropertyOps();
            childPropertyOps.setValue(resolveEntity, childEntity);
        }
        Object result = entity;
        return (T)result;
    }

    public void processProperty(ResourceShapeBuilder builder, RdfPopulatorProperty rdfProperty) {
    }

    @Override
    public <T> T merge(T tmpEntity) {
        RdfType rootRdfType = this.typeFactory.forJavaType(tmpEntity.getClass());
        Node node = rootRdfType.getRootNode(tmpEntity);
        T result = this.merge(tmpEntity, node);
        return result;
    }

    @Override
    public <T> T merge(T srcEntity, Node node) {
        Function<Class<?>, EntityOps> entityOpsFactory = ((RdfTypeFactoryImpl)this.typeFactory).getEntityOpsFactory();
        Class<?> entityClass = srcEntity.getClass();
        EntityId entityId = new EntityId(entityClass, node);
        Object tgtEntity = this.find(entityClass, node);
        EntityOps entityOps = entityOpsFactory.apply(entityClass);
        for (PropertyOps propertyOps : entityOps.getProperties()) {
            Object tgtValue = propertyOps.getValue(tgtEntity);
            EntityId tgtId = this.persistenceContext.getEntityToIdMap().get(tgtValue);
            Node tgtNode = tgtId.getNode();
            Object srcValue = propertyOps.getValue(srcEntity);
            Object mergedValue = this.merge(srcValue, tgtNode);
            propertyOps.setValue(tgtEntity, mergedValue);
        }
        DatasetDescription datasetDescription = this.sparqlService.getDatasetDescription();
        String string = DatasetDescriptionUtils.getSingleDefaultGraphUri((DatasetDescription)datasetDescription);
        if (string == null) {
            throw new RuntimeException("No target graph specified");
        }
        Node g = NodeFactory.createURI((String)string);
        DatasetGraph newState = DatasetGraphFactory.create();
        Graph outGraph = Quad.defaultGraphIRI.equals((Object)g) ? newState.getDefaultGraph() : newState.getGraph(g);
        this.emitTriples(outGraph, tgtEntity);
        DatasetGraph oldState = DatasetGraphFactory.create();
        Graph targetGraph = oldState.getGraph(g);
        if (targetGraph == null) {
            targetGraph = GraphFactory.createDefaultGraph();
            oldState.addGraph(g, targetGraph);
        }
        Diff diff = UpdateDiffUtils.computeDelta((DatasetGraph)newState, (DatasetGraph)oldState);
        UpdateExecutionFactory uef = this.sparqlService.getUpdateExecutionFactory();
        UpdateExecutionUtils.executeUpdate((UpdateExecutionFactory)uef, (Diff)diff);
        Object result = tgtEntity;
        return (T)result;
    }

    @Override
    public RdfTypeFactory getRdfTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public void emitTriples(Graph outGraph, Object entity) {
    }

    @Override
    public void emitTriples(Graph outGraph, Object entity, Node subject) {
        RdfEmitterContextImpl emitterContext = new RdfEmitterContextImpl(this.persistenceContext);
        Node rootNode = emitterContext.requestResolution(entity);
        Map<Node, ResolutionRequest> nodeToResolutionRequest = emitterContext.getNodeToResolutionRequest();
        while (!nodeToResolutionRequest.isEmpty()) {
            Iterator<Map.Entry<Node, ResolutionRequest>> it = nodeToResolutionRequest.entrySet().iterator();
            Map.Entry<Node, ResolutionRequest> e = it.next();
            it.remove();
            Node node = e.getKey();
            ResolutionRequest request = e.getValue();
            Object obj = this.find(request.getType().getClass(), node);
        }
    }
}

