/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.impl.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.aksw.jena_sparql_api.beans.model.EntityOps;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.mapper.context.RdfEmitterContext;
import org.aksw.jena_sparql_api.mapper.context.RdfPersistenceContext;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfPropertyDescriptor;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeComplexBase;
import org.aksw.jena_sparql_api.mapper.model.RdfPopulator;
import org.aksw.jena_sparql_api.mapper.proxy.MethodInterceptorRdf;
import org.aksw.jena_sparql_api.shape.ResourceShapeBuilder;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraph;
import org.springframework.cglib.proxy.Callback;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.Factory;

public class RdfClass
extends RdfTypeComplexBase {
    protected EntityOps entityOps;
    protected Concept concept;
    protected Function<Object, String> defaultIriFn;
    protected List<RdfPopulator> populators = new ArrayList<RdfPopulator>();
    protected Map<String, RdfPropertyDescriptor> propertyDescriptors = new HashMap<String, RdfPropertyDescriptor>();
    protected boolean isPopulated;

    public Collection<RdfPopulator> getPopulators() {
        return this.populators;
    }

    public Collection<RdfPropertyDescriptor> getPropertyDescriptors() {
        Collection<RdfPropertyDescriptor> result = this.propertyDescriptors.values();
        return result;
    }

    public RdfPropertyDescriptor getPropertyDescriptors(String propertyName) {
        RdfPropertyDescriptor result = this.propertyDescriptors.get(propertyName);
        return result;
    }

    public EntityOps getEntityOps() {
        return this.entityOps;
    }

    public Concept getConcept() {
        return this.concept;
    }

    public void setPopulated(boolean isPopulated) {
        this.isPopulated = isPopulated;
    }

    public void checkPopulated() {
        if (this.isPopulated) {
            throw new IllegalStateException("Class has already been populated");
        }
    }

    public void addPropertyDescriptor(RdfPropertyDescriptor propertyDescriptor) {
        this.checkPopulated();
        String name = propertyDescriptor.getName();
        this.propertyDescriptors.put(name, propertyDescriptor);
    }

    public void addPopulator(RdfPopulator populator) {
        this.checkPopulated();
        this.populators.add(populator);
    }

    public boolean isPopulated() {
        return this.isPopulated;
    }

    public RdfClass(EntityOps targetClass, Function<Object, String> defaultIriFn) {
        this.entityOps = targetClass;
        this.defaultIriFn = defaultIriFn;
    }

    @Override
    public Class<?> getEntityClass() {
        return this.entityOps.getAssociatedClass();
    }

    @Override
    public void exposeShape(ResourceShapeBuilder builder) {
        for (RdfPopulator populator : this.populators) {
            populator.exposeShape(builder);
        }
    }

    public static MethodInterceptorRdf getMethodInterceptor(Object o) {
        MethodInterceptorRdf result = null;
        if (o != null && Enhancer.isEnhanced(o.getClass())) {
            Factory factory = (Factory)o;
            Callback callback = factory.getCallback(0);
            result = callback != null && callback instanceof MethodInterceptorRdf ? (MethodInterceptorRdf)callback : null;
        }
        return result;
    }

    @Override
    public Node getRootNode(Object o) {
        Node result;
        MethodInterceptorRdf m = RdfClass.getMethodInterceptor(o);
        Node node = result = m != null ? m.getPresetSubject() : null;
        if (result == null) {
            String str = this.defaultIriFn != null ? this.defaultIriFn.apply(o) : null;
            result = str != null ? NodeFactory.createURI((String)str) : null;
        }
        return result;
    }

    public Object toJava(Node node) {
        Object result;
        if (node == null) {
            result = null;
        } else if (node.isURI()) {
            result = node.getURI();
        } else if (node.isLiteral()) {
            result = node.getLiteralValue();
        } else {
            throw new RuntimeException("not supported (yet)");
        }
        return result;
    }

    @Override
    public void populateEntity(RdfPersistenceContext persistenceContext, Object entity, Node s, Graph inGraph, Consumer<Triple> outSink) {
        for (RdfPopulator pd : this.populators) {
            pd.populateEntity(persistenceContext, entity, inGraph, s, outSink);
        }
    }

    @Override
    public void emitTriples(RdfEmitterContext emitterContext, Object entity, Node s, Graph shapeGraph, Consumer<Triple> out) {
        if (s == null) {
            throw new RuntimeException("Could not determine (iri-)node of entity " + (entity == null ? " null " : entity.getClass().getName()) + " - " + entity);
        }
        for (RdfPopulator populator : this.populators) {
            populator.emitTriples(emitterContext, entity, s, shapeGraph, out);
        }
    }

    @Deprecated
    public Object createProxy(DatasetGraph datasetGraph, Node subject) {
        Object o;
        try {
            o = this.entityOps.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MethodInterceptorRdf interceptor = new MethodInterceptorRdf(o, this, subject, datasetGraph);
        Class<?> beanClass = this.entityOps.getAssociatedClass();
        Object result = Enhancer.create(beanClass, null, (Callback)interceptor);
        return result;
    }

    public String toString() {
        return "RdfClass [entityOps=" + this.entityOps + ", concept=" + this.concept + ", defaultIriFn=" + this.defaultIriFn + ", populators=" + this.populators + ", propertyDescriptors=" + this.propertyDescriptors + ", isPopulated=" + this.isPopulated + "]";
    }

    @Override
    public Object createJavaObject(Node node, Graph graph) {
        if (!this.entityOps.isInstantiable()) {
            throw new RuntimeException("EntityOps is not instantiable: " + this.entityOps);
        }
        Object result = this.entityOps.newInstance();
        return result;
    }

    @Override
    public boolean hasIdentity() {
        boolean result = this.defaultIriFn != null;
        return result;
    }
}

