/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.impl.type;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.aksw.commons.util.strings.StringUtils;
import org.aksw.jena_sparql_api.beans.model.EntityModel;
import org.aksw.jena_sparql_api.beans.model.EntityOps;
import org.aksw.jena_sparql_api.beans.model.PropertyOps;
import org.aksw.jena_sparql_api.mapper.annotation.DefaultIri;
import org.aksw.jena_sparql_api.mapper.annotation.Iri;
import org.aksw.jena_sparql_api.mapper.annotation.IriType;
import org.aksw.jena_sparql_api.mapper.annotation.MappedBy;
import org.aksw.jena_sparql_api.mapper.annotation.MultiValued;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfClass;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfPropertyDescriptor;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeBase;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeIriStr;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeLiteralTyped;
import org.aksw.jena_sparql_api.mapper.model.F_GetValue;
import org.aksw.jena_sparql_api.mapper.model.RdfPopulatorPropertyBase;
import org.aksw.jena_sparql_api.mapper.model.RdfPopulatorPropertyMulti;
import org.aksw.jena_sparql_api.mapper.model.RdfPopulatorPropertySingle;
import org.aksw.jena_sparql_api.mapper.model.RdfType;
import org.aksw.jena_sparql_api.mapper.model.RdfTypeFactory;
import org.aksw.jena_sparql_api.stmt.SparqlRelationParser;
import org.aksw.jena_sparql_api.stmt.SparqlRelationParserImpl;
import org.aksw.jena_sparql_api.util.frontier.Frontier;
import org.aksw.jena_sparql_api.util.frontier.FrontierImpl;
import org.aksw.jena_sparql_api.utils.UriUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Prologue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

public class RdfTypeFactoryImpl
implements RdfTypeFactory {
    private static final Logger logger = LoggerFactory.getLogger(RdfTypeFactoryImpl.class);
    protected ExpressionParser parser;
    protected EvaluationContext evalContext;
    protected ParserContext parserContext;
    protected Prologue prologue;
    protected SparqlRelationParser relationParser;
    protected Function<Class<?>, EntityOps> entityOpsFactory;
    protected Map<Class<?>, RdfType> classToRdfType = new HashMap();
    protected TypeMapper typeMapper;
    protected ConversionService conversionService;

    public RdfTypeFactoryImpl(ExpressionParser parser, ParserContext parserContext, EvaluationContext evalContext, TypeMapper typeMapper, Prologue prologue, SparqlRelationParser relationParser, Function<Class<?>, EntityOps> entityOpsFactory, ConversionService conversionService) {
        this.parser = parser;
        this.evalContext = evalContext;
        this.parserContext = parserContext;
        this.typeMapper = typeMapper;
        this.prologue = prologue;
        this.relationParser = relationParser;
        this.entityOpsFactory = entityOpsFactory;
        this.conversionService = conversionService;
    }

    public Function<Class<?>, EntityOps> getEntityOpsFactory() {
        return this.entityOpsFactory;
    }

    public Prologue getPrologue() {
        return this.prologue;
    }

    public Map<Class<?>, RdfType> getClassToRdfType() {
        return this.classToRdfType;
    }

    @Override
    public RdfType forJavaType(Class<?> clazz) {
        RdfType result = this.getOrAllocateRdfType(clazz);
        if (result instanceof RdfClass) {
            RdfClass tmp = (RdfClass)result;
            this.populateClasses(tmp);
        }
        return result;
    }

    protected RdfType getOrAllocateRdfType(Class<?> clazz) {
        RdfType result = this.classToRdfType.get(clazz);
        if (result == null) {
            result = this.allocateRdfType(clazz);
            this.classToRdfType.put(clazz, result);
        }
        return result;
    }

    protected RdfType allocateRdfType(Class<?> clazz) {
        RDFDatatype dtype = this.typeMapper.getTypeByClass(clazz);
        boolean isPrimitive = dtype != null;
        RdfTypeBase result = isPrimitive ? new RdfTypeLiteralTyped(this, dtype) : this.allocateRdfClass(clazz);
        return result;
    }

    protected RdfClass allocateRdfClass(Class<?> clazz) {
        EntityOps entityOps = this.entityOpsFactory.apply(clazz);
        RdfClass result = this.allocateRdfClass(entityOps);
        return result;
    }

    protected RdfClass allocateRdfClass(EntityOps entityOps) {
        org.aksw.jena_sparql_api.mapper.annotation.RdfType rdfType = entityOps.findAnnotation(org.aksw.jena_sparql_api.mapper.annotation.RdfType.class);
        DefaultIri defaultIri = entityOps.findAnnotation(DefaultIri.class);
        F_GetValue<String> defaultIriFn = null;
        if (defaultIri != null) {
            String iriStr = defaultIri.value();
            Expression expression = this.parser.parseExpression(iriStr, this.parserContext);
            defaultIriFn = new F_GetValue<String>(String.class, expression, this.evalContext);
        }
        RdfClass result = new RdfClass(entityOps, defaultIriFn);
        return result;
    }

    protected String resolveIriExpr(String exprStr) {
        Expression expression = this.parser.parseExpression(exprStr, this.parserContext);
        String tmp = (String)expression.getValue(this.evalContext, String.class);
        tmp = tmp.trim();
        PrefixMapping prefixMapping = this.prologue.getPrefixMapping();
        String result = prefixMapping.expandPrefix(tmp);
        return result;
    }

    private void populateClasses(RdfClass rootRdfClass) {
        FrontierImpl frontier = FrontierImpl.createIdentityFrontier();
        frontier.add((Object)rootRdfClass);
        while (!frontier.isEmpty()) {
            RdfClass rdfClass = (RdfClass)frontier.next();
            this.initProperties(rdfClass, (Frontier<RdfClass>)frontier);
        }
    }

    private void initProperties(RdfClass rdfClass, Frontier<RdfClass> frontier) {
        if (!rdfClass.isPopulated()) {
            logger.debug("Initializing RdfClass for [" + rdfClass.getEntityOps().getAssociatedClass().getName() + "]");
            EntityOps entityOps = rdfClass.getEntityOps();
            for (PropertyOps propertyOps : entityOps.getProperties()) {
                this.processProperty(rdfClass, entityOps, propertyOps, frontier);
            }
        }
        rdfClass.setPopulated(true);
    }

    protected void processProperty(RdfClass rdfClass, EntityOps entityOps, PropertyOps pd, Frontier<RdfClass> frontier) {
        boolean isMappedBy;
        Object result = null;
        Class<?> clazz = entityOps.getAssociatedClass();
        String propertyName = pd.getName();
        boolean isReadable = pd.isReadable();
        boolean isWritable = pd.isWritable();
        boolean isCandidate = isReadable && isWritable;
        Iri iriAnn = pd.findAnnotation(Iri.class);
        String iriExprStr = iriAnn == null ? null : iriAnn.value();
        String iriStr = iriExprStr == null ? null : this.resolveIriExpr(iriExprStr);
        boolean hasIri = iriStr != null && !iriStr.isEmpty();
        String mappedBy = (String)AnnotationUtils.getValue((Annotation)((Annotation)pd.findAnnotation(MappedBy.class)));
        boolean bl = isMappedBy = mappedBy != null;
        if (isCandidate && (hasIri || isMappedBy)) {
            logger.debug("Annotation on property " + propertyName + " detected: " + iriStr);
            Node predicate = iriStr != null ? NodeFactory.createURI((String)iriStr) : null;
            this.processProperty(rdfClass, entityOps, pd, predicate, frontier);
        } else {
            logger.debug("Ignoring property " + propertyName);
        }
    }

    public static Class<?> extractItemType(Type genericType) {
        ParameterizedType pt;
        Type[] types;
        Class result = null;
        if (genericType instanceof ParameterizedType && (types = (pt = (ParameterizedType)genericType).getActualTypeArguments()).length == 1) {
            result = (Class)types[0];
        }
        return result;
    }

    protected void processProperty(RdfClass rdfClass, EntityOps beanInfo, PropertyOps pd, Node predicate, Frontier<RdfClass> frontier) {
        BiFunction<Object, Object, Node> defaultIriFn;
        RdfType targetRdfType;
        RDFDatatype dtype;
        boolean isMultiValued;
        Class<?> entityClass = beanInfo.getAssociatedClass();
        String propertyName = pd.getName();
        Class<?> propertyType = pd.getType();
        boolean isCollectionProperty = Collection.class.isAssignableFrom(propertyType);
        boolean bl = isMultiValued = pd.findAnnotation(MultiValued.class) != null;
        if (isMultiValued && !isCollectionProperty) {
            throw new RuntimeException("Invalid annotation: " + entityClass + "." + pd.getName() + ":  is declared MultiValued however is not a Collection");
        }
        if (isCollectionProperty) {
            Type paramType = pd.getWriteMethod().getGenericParameterTypes()[0];
            propertyType = RdfTypeFactoryImpl.extractItemType(paramType);
        }
        boolean isLiteral = (dtype = this.typeMapper.getTypeByClass(propertyType)) != null;
        IriType iriType = pd.findAnnotation(IriType.class);
        if (iriType == null) {
            if (isLiteral) {
                targetRdfType = new RdfTypeLiteralTyped(this, dtype);
            } else {
                RdfClass tmp;
                targetRdfType = this.getOrAllocateRdfType(propertyType);
                if (targetRdfType instanceof RdfClass && !(tmp = (RdfClass)targetRdfType).isPopulated()) {
                    frontier.add((Object)tmp);
                }
            }
        } else {
            Assert.isTrue((boolean)String.class.isAssignableFrom(propertyType));
            targetRdfType = new RdfTypeIriStr();
        }
        DefaultIri defaultIri = pd.findAnnotation(DefaultIri.class);
        if (defaultIri == null) {
            defaultIriFn = (entity, value) -> targetRdfType.getRootNode(value);
        } else {
            String defaultIriStr = defaultIri.value();
            Expression expression = this.parser.parseExpression(defaultIriStr, this.parserContext);
            Function defaultIriFnTmp = new F_GetValue<String>(String.class, expression, this.evalContext).andThen(iri -> NodeFactory.createURI((String)iri));
            defaultIriFn = (entity, value) -> (Node)defaultIriFnTmp.apply(entity);
        }
        RdfPropertyDescriptor descriptor = new RdfPropertyDescriptor(propertyName, targetRdfType, "");
        RdfPopulatorPropertyBase populator = isCollectionProperty ? new RdfPopulatorPropertyMulti(pd, predicate, targetRdfType, defaultIriFn) : new RdfPopulatorPropertySingle(pd, predicate, targetRdfType, defaultIriFn);
        rdfClass.addPropertyDescriptor(descriptor);
        rdfClass.addPopulator(populator);
    }

    public static RdfTypeFactoryImpl createDefault() {
        ConversionServiceFactoryBean bean = new ConversionServiceFactoryBean();
        bean.afterPropertiesSet();
        ConversionService conversionService = bean.getObject();
        Prologue prologue = new Prologue();
        RdfTypeFactoryImpl result = RdfTypeFactoryImpl.createDefault(prologue, null, conversionService);
        return result;
    }

    public static RdfTypeFactoryImpl createDefault(Prologue prologue, Function<Class<?>, EntityOps> entityOpsFactory, ConversionService conversionService) {
        prologue = prologue != null ? prologue : new Prologue();
        entityOpsFactory = entityOpsFactory != null ? entityOpsFactory : clazz -> EntityModel.createDefaultModel(clazz, conversionService);
        StandardEvaluationContext evalContext = new StandardEvaluationContext();
        TemplateParserContext parserContext = new TemplateParserContext();
        try {
            evalContext.registerFunction("md5", StringUtils.class.getDeclaredMethod("md5Hash", String.class));
            evalContext.registerFunction("localName", UriUtils.class.getDeclaredMethod("getLocalName", String.class));
            evalContext.registerFunction("nameSpace", UriUtils.class.getDeclaredMethod("getNameSpace", String.class));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SpelExpressionParser parser = new SpelExpressionParser();
        SparqlRelationParserImpl relationParser = SparqlRelationParserImpl.create((Syntax)Syntax.syntaxARQ, (Prologue)prologue);
        TypeMapper typeMapper = TypeMapper.getInstance();
        RdfTypeFactoryImpl result = new RdfTypeFactoryImpl((ExpressionParser)parser, (ParserContext)parserContext, (EvaluationContext)evalContext, typeMapper, prologue, (SparqlRelationParser)relationParser, entityOpsFactory, conversionService);
        return result;
    }
}

