/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.model;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.aksw.jena_sparql_api.beans.model.PropertyOps;
import org.aksw.jena_sparql_api.mapper.context.RdfEmitterContext;
import org.aksw.jena_sparql_api.mapper.context.RdfPersistenceContext;
import org.aksw.jena_sparql_api.mapper.model.RdfPopulatorPropertyBase;
import org.aksw.jena_sparql_api.mapper.model.RdfType;
import org.aksw.jena_sparql_api.shape.ResourceShapeBuilder;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;

public class RdfPopulatorPropertyMulti
extends RdfPopulatorPropertyBase {
    public RdfPopulatorPropertyMulti(PropertyOps propertyOps, Node predicate, RdfType targetRdfType, BiFunction<Object, Object, Node> createTargetNode) {
        super(propertyOps, predicate, targetRdfType, createTargetNode);
    }

    @Override
    public void emitTriples(RdfEmitterContext emitterContext, Object entity, Node subject, Graph shapeGraph, Consumer<Triple> out) {
        Collection items = (Collection)this.propertyOps.getValue(entity);
        for (Object item : items) {
            Node o = this.targetRdfType.getRootNode(item);
            Triple t = new Triple(subject, this.predicate, o);
            out.accept(t);
        }
    }

    public static Object getOrCreateBean(Object entity, PropertyOps propertyOps) {
        Object result = propertyOps.getValue(entity);
        if (result == null) {
            Class<?> collectionType = propertyOps.getType();
            try {
                result = collectionType.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            propertyOps.setValue(entity, result);
        }
        return result;
    }

    @Override
    public void populateEntity(RdfPersistenceContext populationContext, Object bean, Graph graph, Node subject, Consumer<Triple> outSink) {
        Collection collection = (Collection)RdfPopulatorPropertyMulti.getOrCreateBean(bean, this.propertyOps);
        for (Triple t : graph.find(subject, this.predicate, Node.ANY).toSet()) {
            outSink.accept(t);
            Node o = t.getObject();
            Class<?> valueClass = this.propertyOps.getClass();
            Object value = populationContext.entityFor(valueClass, o, () -> this.targetRdfType.createJavaObject(o, graph));
            collection.add(value);
        }
    }

    @Override
    public void exposeShape(ResourceShapeBuilder shapeBuilder) {
        shapeBuilder.out(this.predicate);
    }
}

