/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.model;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.aksw.jena_sparql_api.beans.model.PropertyOps;
import org.aksw.jena_sparql_api.mapper.context.RdfEmitterContext;
import org.aksw.jena_sparql_api.mapper.context.RdfPersistenceContext;
import org.aksw.jena_sparql_api.mapper.model.RdfPopulatorPropertyBase;
import org.aksw.jena_sparql_api.mapper.model.RdfType;
import org.aksw.jena_sparql_api.shape.ResourceShapeBuilder;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;

public class RdfPopulatorPropertySingle
extends RdfPopulatorPropertyBase {
    public RdfPopulatorPropertySingle(PropertyOps propertyOps, Node predicate, RdfType targetRdfType, BiFunction<Object, Object, Node> createTargetIri) {
        super(propertyOps, predicate, targetRdfType, createTargetIri);
    }

    @Override
    public void emitTriples(RdfEmitterContext emitterContext, Object entity, Node subject, Graph shapeGraph, Consumer<Triple> outSink) {
        Object value = this.propertyOps.getValue(entity);
        if (value != null) {
            Supplier<Node> defaultNodeGenerator = this.createTargetNode == null ? null : () -> (Node)this.createTargetNode.apply(entity, value);
            Node o = emitterContext.requestResolution(value);
            Triple t = new Triple(subject, this.predicate, o);
            outSink.accept(t);
        }
    }

    @Override
    public void populateEntity(RdfPersistenceContext persistenceContext, Object entity, Graph inGraph, Node subject, Consumer<Triple> outSink) {
        Object childEntity;
        Node node;
        List triples = inGraph.find(subject, this.predicate, Node.ANY).toList();
        Triple t = (Triple)Iterables.getFirst((Iterable)triples, null);
        if (t != null) {
            node = t.getObject();
            outSink.accept(t);
        } else {
            node = null;
        }
        if (node == null && this.createTargetNode != null && (childEntity = this.propertyOps.getValue(entity)) != null) {
            node = (Node)this.createTargetNode.apply(entity, childEntity);
        }
        if (node != null) {
            persistenceContext.requestResolution(this.propertyOps, entity, node);
        }
    }

    @Override
    public void exposeShape(ResourceShapeBuilder shapeBuilder) {
        shapeBuilder.out(this.predicate);
    }

    public String toString() {
        return "RdfPopulatorPropertySingle [propertyName=" + this.propertyOps.getName() + ", predicate=" + this.predicate + ", targetRdfType=" + this.targetRdfType + "]";
    }

    @Override
    public PropertyOps getPropertyOps() {
        return this.propertyOps;
    }
}

