/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.model;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.mapper.model.TypeDecider;
import org.aksw.jena_sparql_api.shape.ResourceShapeBuilder;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.util.ModelUtils;
import org.apache.jena.vocabulary.RDF;

public class TypeDeciderImpl
implements TypeDecider {
    protected Property typeProperty = RDF.type;
    protected Map<Node, Class<?>> nodeToClass;
    protected Map<Class<?>, Node> classToNode;

    public void addMapping(Node node, Class<?> clazz) {
        this.nodeToClass.put(node, clazz);
        this.classToNode.put(clazz, node);
    }

    @Override
    public void exposeShape(ResourceShapeBuilder rsb) {
        rsb.out(this.typeProperty);
    }

    @Override
    public Collection<Class<?>> getApplicableTypes(Resource subject) {
        Set<Class<?>> result = subject.listProperties(this.typeProperty).toSet().stream().map(stmt -> stmt.getObject().asNode()).map(o -> this.nodeToClass.get(o)).filter(o -> o != null).collect(Collectors.toSet());
        return result;
    }

    @Override
    public void writeTypeTriples(Resource outResource, Object entity) {
        Class<?> clazz = entity.getClass();
        Node type = this.classToNode.get(clazz);
        Model model = outResource.getModel();
        RDFNode rdfNode = ModelUtils.convertGraphNodeToRDFNode((Node)type, (Model)model);
        outResource.addProperty(this.typeProperty, rdfNode);
    }
}

