/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.beans.model;

import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.beans.model.EntityOps;
import org.aksw.jena_sparql_api.beans.model.PropertyOps;

public class MapEntityOps
extends AbstractMap<String, Object> {
    protected EntityOps entityOps;
    protected Object entity;

    public MapEntityOps(EntityOps entityOps, Object entity) {
        this.entityOps = entityOps;
        this.entity = entity;
    }

    public EntityOps getEntityOps() {
        return this.entityOps;
    }

    public Object getEntity() {
        return this.entity;
    }

    @Override
    public Object get(Object key) {
        PropertyOps propertyOps;
        Object result = null;
        if (key instanceof String && (propertyOps = this.entityOps.getProperty((String)key)) != null) {
            result = propertyOps.getValue(this.entity);
        }
        return result;
    }

    @Override
    public Object put(String key, Object value) {
        PropertyOps propertyOps = this.entityOps.getProperty(key);
        if (propertyOps == null) {
            throw new RuntimeException("Cannot set value of non-existent property " + key);
        }
        propertyOps.setValue(this.entity, value);
        return value;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> result = new HashSet<Map.Entry<String, Object>>();
        for (PropertyOps propertyOps : this.entityOps.getProperties()) {
            String name = propertyOps.getName();
            Object value = propertyOps.getValue(this.entity);
            AbstractMap.SimpleEntry<String, Object> entry = new AbstractMap.SimpleEntry<String, Object>(name, value);
            result.add(entry);
        }
        return result;
    }
}

