/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.context;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.aksw.jena_sparql_api.mapper.context.EntityContext;

public class EntityContextImpl<T>
implements EntityContext<T> {
    protected Map<T, Map<String, Object>> entityStates;

    public EntityContextImpl() {
        this(new HashMap());
    }

    public EntityContextImpl(Map<T, Map<String, Object>> beanStates) {
        this.entityStates = beanStates;
    }

    @Override
    public Map<String, Object> get(Object entity) {
        this.checkManaged(entity);
        Map<String, Object> result = this.entityStates.get(entity);
        return result;
    }

    @Override
    public Map<String, Object> getOrCreate(T entity) {
        Map<String, Object> result = this.isManaged(entity) ? this.get(entity) : this.register(entity);
        return result;
    }

    @Override
    public Map<String, Object> register(T entity) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.entityStates.put(entity, result);
        return result;
    }

    public void checkManaged(Object entity) {
        if (!this.isManaged(entity)) {
            throw new RuntimeException("Entity was expected to be managed: " + entity);
        }
    }

    @Override
    public Map<String, Object> getState(Object entity) {
        this.checkManaged(entity);
        Map<String, Object> result = this.entityStates.get(entity);
        return result;
    }

    @Override
    public boolean isManaged(Object entity) {
        boolean result = this.entityStates.containsKey(entity);
        return result;
    }

    public static <T> EntityContext<T> createIdentityContext(Class<T> clazz) {
        IdentityHashMap map = new IdentityHashMap();
        EntityContextImpl result = new EntityContextImpl(map);
        return result;
    }

    @Override
    public void setAttribute(T entity, String attribute, Object value) {
        Map<String, Object> map = this.getOrCreate(entity);
        map.put(attribute, value);
    }

    @Override
    public <X> X getAttribute(Object entity, String attribute, X defaultValue) {
        X result = this.isManaged(entity) ? this.getState(entity).get(attribute) : defaultValue;
        return result;
    }
}

