/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.impl.engine;

import java.util.Map;
import java.util.function.Function;
import javax.persistence.criteria.Expression;
import org.aksw.jena_sparql_api.concepts.Relation;
import org.aksw.jena_sparql_api.mapper.impl.engine.RdfMapperEngine;
import org.aksw.jena_sparql_api.mapper.impl.type.PathFragment;
import org.aksw.jena_sparql_api.mapper.impl.type.PathResolver;
import org.aksw.jena_sparql_api.mapper.model.RdfType;
import org.apache.jena.sparql.core.Var;

public class PathResolverImpl
implements PathResolver {
    protected Map<Expression<?>, Map<Var, Var>> exprToVarMap;
    protected PathResolverImpl parent;
    protected PathFragment pathFragment;
    protected RdfMapperEngine mapperEngine;
    protected String reachingPropertyName;

    @Override
    public PathResolverImpl getParent() {
        return this.parent;
    }

    public PathFragment getPathFragment() {
        return this.pathFragment;
    }

    public PathResolverImpl(PathFragment pathFragment, RdfMapperEngine mapperEngine, String reachingPropertyName, PathResolverImpl parent) {
        this.pathFragment = pathFragment;
        this.mapperEngine = mapperEngine;
        this.reachingPropertyName = reachingPropertyName;
        this.parent = parent;
    }

    public PathResolver resolve(Function<Class<?>, RdfType> rdfTypeFactory, Class<?> javaClass, String propertyName) {
        RdfType rdfType = rdfTypeFactory.apply(javaClass);
        PathResolver result = this.resolve(rdfType, propertyName);
        return result;
    }

    public PathResolver resolve(RdfType rdfType, String propertyName) {
        PathFragment pathFragment = rdfType.resolve(propertyName);
        PathResolverImpl result = new PathResolverImpl(pathFragment, this.mapperEngine, propertyName, this);
        return result;
    }

    public PathResolver resolve(RdfMapperEngine mapperEngine, PathFragment pathFragment, String propertyName) {
        PathResolver result;
        PathResolver tmp = pathFragment.getNextResolver();
        if (tmp != null) {
            result = tmp.resolve(propertyName);
        } else {
            RdfType rdfType = pathFragment.getRdfType();
            if (rdfType != null) {
                result = this.resolve(rdfType, propertyName);
            } else {
                Class<?> javaClass = pathFragment.getJavaClass();
                if (javaClass != null) {
                    result = this.resolve(mapperEngine.getRdfTypeFactory()::forJavaType, javaClass, propertyName);
                } else {
                    throw new RuntimeException("Could not resolve pathFragment: " + pathFragment);
                }
            }
        }
        return result;
    }

    @Override
    public PathResolver resolve(String propertyName) {
        PathResolver result = this.resolve(this.mapperEngine, this.pathFragment, propertyName);
        return result;
    }

    @Override
    public Relation getRelation() {
        Relation result = this.pathFragment.getRelation();
        return result;
    }
}

