/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.impl.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.collections.diff.Diff;
import org.aksw.jena_sparql_api.beans.model.EntityOps;
import org.aksw.jena_sparql_api.beans.model.PropertyOps;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.concepts.Relation;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.core.UpdateExecutionFactory;
import org.aksw.jena_sparql_api.core.utils.ServiceUtils;
import org.aksw.jena_sparql_api.core.utils.UpdateDiffUtils;
import org.aksw.jena_sparql_api.core.utils.UpdateExecutionUtils;
import org.aksw.jena_sparql_api.lookup.LookupService;
import org.aksw.jena_sparql_api.mapper.context.EntityId;
import org.aksw.jena_sparql_api.mapper.context.RdfPersistenceContext;
import org.aksw.jena_sparql_api.mapper.impl.engine.EntityState;
import org.aksw.jena_sparql_api.mapper.impl.engine.PathResolverImpl;
import org.aksw.jena_sparql_api.mapper.impl.engine.RdfMapperEngine;
import org.aksw.jena_sparql_api.mapper.impl.type.EntityFragment;
import org.aksw.jena_sparql_api.mapper.impl.type.PathFragment;
import org.aksw.jena_sparql_api.mapper.impl.type.PathResolver;
import org.aksw.jena_sparql_api.mapper.impl.type.PlaceholderInfo;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeFactoryImpl;
import org.aksw.jena_sparql_api.mapper.impl.type.ResolutionTask;
import org.aksw.jena_sparql_api.mapper.impl.type.ResourceFragment;
import org.aksw.jena_sparql_api.mapper.model.RdfMapperProperty;
import org.aksw.jena_sparql_api.mapper.model.RdfType;
import org.aksw.jena_sparql_api.mapper.model.RdfTypeFactory;
import org.aksw.jena_sparql_api.mapper.model.ShapeExposable;
import org.aksw.jena_sparql_api.mapper.model.TypeDecider;
import org.aksw.jena_sparql_api.mapper.model.TypeDeciderImpl;
import org.aksw.jena_sparql_api.shape.ResourceShape;
import org.aksw.jena_sparql_api.shape.ResourceShapeBuilder;
import org.aksw.jena_sparql_api.shape.lookup.MapServiceResourceShape;
import org.aksw.jena_sparql_api.utils.DatasetDescriptionUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.util.ModelUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfMapperEngineImpl
implements RdfMapperEngine {
    private static final Logger logger = LoggerFactory.getLogger(RdfMapperEngine.class);
    protected Prologue prologue;
    protected SparqlService sparqlService;
    protected RdfTypeFactory typeFactory;
    protected Map<EntityId, EntityState> originalState = new HashMap<EntityId, EntityState>();
    protected TypeDecider typeDecider = new TypeDeciderImpl();

    @Override
    public SparqlService getSparqlService() {
        return this.sparqlService;
    }

    @Override
    public TypeDecider getTypeDecider() {
        return this.typeDecider;
    }

    public RdfMapperEngineImpl(SparqlService sparqlService) {
        this(sparqlService, RdfTypeFactoryImpl.createDefault(), new Prologue(), null);
    }

    public RdfMapperEngineImpl(SparqlService sparqlService, Prologue prologue) {
        this(sparqlService, RdfTypeFactoryImpl.createDefault(prologue), prologue, null);
    }

    public RdfMapperEngineImpl(SparqlService sparqlService, RdfTypeFactory typeFactory) {
        this(sparqlService, typeFactory, new Prologue(), null);
    }

    public RdfMapperEngineImpl(SparqlService sparqlService, RdfTypeFactory typeFactory, Prologue prologue) {
        this(sparqlService, typeFactory, prologue, null);
    }

    public RdfMapperEngineImpl(SparqlService sparqlService, RdfTypeFactory typeFactory, Prologue prologue, RdfPersistenceContext persistenceContext) {
        this.sparqlService = sparqlService;
        this.typeFactory = typeFactory;
        this.prologue = prologue;
    }

    public RdfTypeFactory getTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public Prologue getPrologue() {
        return this.prologue;
    }

    public <T> LookupService<Node, T> getLookupService(Class<T> clazz) {
        return null;
    }

    @Override
    public String getIri(Object entity) {
        String result = null;
        for (EntityState entityState : this.originalState.values()) {
            if (entityState.getEntity() != entity) continue;
            RDFNode tmp = entityState.getShapeResource();
            if (tmp != null && tmp.isResource()) {
                result = tmp.asResource().getURI();
                break;
            }
            throw new RuntimeException("Entity exists but does not have an IRI - should not happen");
        }
        return result;
    }

    @Override
    public <T> List<T> list(Class<T> clazz, Concept filterConcept) {
        QueryExecutionFactory qef = this.sparqlService.getQueryExecutionFactory();
        List nodes = ServiceUtils.fetchList((QueryExecutionFactory)qef, (Concept)filterConcept);
        List<T> result = this.list(clazz, nodes);
        return result;
    }

    public <T> List<T> list(Class<T> clazz, List<Node> nodes) {
        ArrayList<T> result = new ArrayList<T>(nodes.size());
        for (Node node : nodes) {
            T entity = this.find(clazz, node);
            result.add(entity);
        }
        return result;
    }

    public static RDFNode fetch(Prologue prologue, SparqlService sparqlService, ShapeExposable shapeSupplier, Node node) {
        Map<Node, RDFNode> tmp = RdfMapperEngineImpl.fetch(prologue, sparqlService, shapeSupplier, Collections.singletonList(node));
        RDFNode result = tmp.get(node);
        return result;
    }

    public Map<Node, RDFNode> fetch(ShapeExposable shapeSupplier, Collection<Node> nodes) {
        Map<Node, RDFNode> result = RdfMapperEngineImpl.fetch(this.prologue, this.sparqlService, shapeSupplier, nodes);
        return result;
    }

    public static Map<Node, RDFNode> fetch(Prologue prologue, SparqlService sparqlService, ShapeExposable shapeSupplier, Collection<Node> nodes) {
        Map<Node, RDFNode> result;
        ResourceShapeBuilder builder = new ResourceShapeBuilder(prologue);
        shapeSupplier.exposeShape(builder);
        ResourceShape shape = builder.getResourceShape();
        if (!shape.isEmpty()) {
            QueryExecutionFactory qef = sparqlService.getQueryExecutionFactory();
            LookupService ls = MapServiceResourceShape.createLookupService((QueryExecutionFactory)qef, (ResourceShape)shape);
            Map map = (Map)ls.apply(nodes);
            result = map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
                Model m = ModelFactory.createModelForGraph((Graph)((Graph)e.getValue()));
                RDFNode r = ModelUtils.convertGraphNodeToRDFNode((Node)((Node)e.getKey()), (Model)m);
                return r;
            }));
        } else {
            result = Collections.emptyMap();
        }
        return result;
    }

    public Resource fetch(RdfType type, Node node) {
        Resource result;
        ResourceShapeBuilder builder = new ResourceShapeBuilder(this.prologue);
        type.exposeShape(builder);
        ResourceShape shape = builder.getResourceShape();
        if (!shape.isEmpty()) {
            QueryExecutionFactory qef = this.sparqlService.getQueryExecutionFactory();
            LookupService ls = MapServiceResourceShape.createLookupService((QueryExecutionFactory)qef, (ResourceShape)shape);
            Map map = (Map)ls.apply(Collections.singleton(node));
            Graph g = (Graph)map.get(node);
            Model m = g == null ? ModelFactory.createDefaultModel() : ModelFactory.createModelForGraph((Graph)g);
            RDFNode n = ModelUtils.convertGraphNodeToRDFNode((Node)node, (Model)m);
            result = n.asResource();
        } else {
            result = null;
        }
        return result;
    }

    public static Set<Class<?>> getNonSubsumedClasses(Collection<Class<?>> classes) {
        Set<Class<?>> result = classes.stream().filter(c -> classes.stream().filter(d -> !c.equals(d)).noneMatch(c::isAssignableFrom)).collect(Collectors.toSet());
        return result;
    }

    public static Set<Class<?>> getMostSpecificSubclasses(Class<?> given, Collection<Class<?>> classes) {
        Set<Class<?>> tmp = classes.stream().filter(given::isAssignableFrom).collect(Collectors.toSet());
        Set<Class<?>> result = RdfMapperEngineImpl.getNonSubsumedClasses(tmp);
        return result;
    }

    @Override
    public <T> T find(Class<T> clazz, Node node) {
        Object o;
        EntityState es = this.loadEntity(clazz, node);
        Object result = o = es.getEntity();
        return (T)result;
    }

    public EntityState loadEntity(Class<?> clazz, Node node) {
        EntityFragment entityFragment;
        RDFNode rn;
        RDFNode rdfNode;
        EntityId entityId = new EntityId(clazz, node);
        logger.debug("Entity lookup with " + entityId);
        Objects.requireNonNull(clazz);
        Objects.requireNonNull(node);
        EntityState entityState = this.originalState.get(entityId);
        Object entity = entityState == null ? null : entityState.getEntity();
        Class<?> actualClazz = clazz;
        if (entity == null && (rdfNode = RdfMapperEngineImpl.fetch(this.prologue, this.sparqlService, (ShapeExposable)this.typeDecider, node)) != null) {
            Collection<Class<?>> classes = this.typeDecider.getApplicableTypes(rdfNode.asResource());
            Set<Class<?>> mscs = RdfMapperEngineImpl.getMostSpecificSubclasses(clazz, classes);
            if (mscs.isEmpty()) {
                throw new RuntimeException("No applicable type found for " + node + " [" + clazz.getName() + "]");
            }
            if (mscs.size() > 1) {
                throw new RuntimeException("Multiple non-subsumed sub-class candidates of " + clazz + " found: " + mscs);
            }
            actualClazz = mscs.iterator().next();
        }
        RdfType rdfType = this.typeFactory.forJavaType(actualClazz);
        if (entity == null) {
            rn = this.fetch(rdfType, node);
            if (rn == null) {
                rn = ModelUtils.convertGraphNodeToRDFNode((Node)node, (Model)ModelFactory.createDefaultModel());
            }
            entity = rdfType.createJavaObject(rn);
        } else {
            rn = entityState.getCurrentResource();
            if (rn == null) {
                rn = entityState.getShapeResource();
            }
        }
        if (rn.isResource()) {
            Resource r = rn.asResource();
            entityFragment = rdfType.populate(r, entity);
            Class<?> entityClass = entity.getClass();
            this.typeDecider.writeTypeTriples(r, entityClass);
            this.populateEntity(entityFragment);
        } else {
            entityFragment = new EntityFragment(entity);
        }
        ResourceFragment resourceFragment = null;
        EntityState result = new EntityState(entity, rn, resourceFragment, entityFragment);
        this.originalState.merge(entityId, result, (? super V o, ? super V n) -> {
            n.getDependentEntityIds().addAll(o.getDependentEntityIds());
            return n;
        });
        return result;
    }

    void populateEntity(EntityFragment entityFragment) {
        for (ResolutionTask task : entityFragment.getTasks()) {
            ArrayList<Object> resolutions = new ArrayList<Object>();
            for (PlaceholderInfo placeholder : task.getPlaceholders()) {
                Object value;
                RdfType targetRdfType = placeholder.getTargetRdfType();
                Class<?> valueClass = targetRdfType != null ? targetRdfType.getEntityClass() : placeholder.getTargetClass();
                Objects.requireNonNull(valueClass);
                RDFNode valueRdfNode = placeholder.getRdfNode();
                if (valueRdfNode != null) {
                    Node valueNode = valueRdfNode.asNode();
                    EntityState valueState = this.loadEntity(valueClass, valueNode);
                    value = valueState.getEntity();
                } else {
                    value = null;
                }
                resolutions.add(value);
            }
            task.resolve(resolutions);
        }
    }

    public Node resolve(Node s, Node p) {
        ResourceShapeBuilder rsb = new ResourceShapeBuilder();
        rsb.out(p);
        ShapeExposable se = x -> x.getResourceShape();
        Property pp = ResourceFactory.createProperty((String)p.getURI());
        RDFNode rdfNode = this.fetch(se, Collections.singleton(s)).get(s);
        rdfNode = rdfNode == null ? null : rdfNode.asResource().getProperty(pp).getObject();
        Node result = rdfNode.asNode();
        return result;
    }

    @Override
    public <T> T merge(T tmpEntity) {
        RdfType rootRdfType = this.typeFactory.forJavaType(tmpEntity.getClass());
        Node node = rootRdfType.getRootNode(tmpEntity);
        T result = this.merge(tmpEntity, node);
        return result;
    }

    public Object find(EntityId entityId) {
        Class<?> entityClass = entityId.getEntityClass();
        Node node = entityId.getNode();
        Object result = this.find(entityClass, node);
        return result;
    }

    @Override
    public void remove(Object entity) {
        Class<?> entityClazz = entity.getClass();
        RdfType rdfType = this.typeFactory.forJavaType(entityClazz);
        Node node = rdfType.getRootNode(entity);
        this.remove(node, entityClazz);
    }

    @Override
    public void remove(Node node, Class<?> clazz) {
        EntityState entityState = this.loadEntity(clazz, node);
        for (EntityId entityId : entityState.getDependentEntityIds()) {
            this.remove(entityId.getNode(), entityId.getEntityClass());
        }
        entityState.setCurrentResource(entityState.getShapeResource().inModel(ModelFactory.createDefaultModel()));
        this.commit();
    }

    @Override
    public <T> T merge(T srcEntity, Node node) {
        T result = this.merge(srcEntity, node, null);
        return result;
    }

    public <T> T merge(T srcEntity, Node node, Class<?> entityClass) {
        Object entity;
        EntityId entityId = this.merge(srcEntity, node, entityClass, null);
        EntityState entityState = this.originalState.get(entityId);
        Object result = entity = entityState == null ? null : entityState.getEntity();
        return (T)result;
    }

    public EntityId merge(Object srcEntity, Node node, Class<?> entityClass, RdfType rdfClass) {
        Objects.requireNonNull(srcEntity);
        Objects.requireNonNull(node);
        entityClass = entityClass != null ? entityClass : srcEntity.getClass();
        rdfClass = rdfClass != null ? rdfClass : this.typeFactory.forJavaType(entityClass);
        Function<Class<?>, EntityOps> entityOpsFactory = ((RdfTypeFactoryImpl)this.typeFactory).getEntityOpsFactory();
        EntityId entityId = new EntityId(entityClass, node);
        EntityState entityState = this.loadEntity(entityClass, node);
        Object tgtEntity = entityState.getEntity();
        Resource priorState = entityState.getShapeResource().asResource();
        ResourceFragment r = new ResourceFragment();
        rdfClass.exposeFragment(r, priorState, srcEntity);
        Resource exposedS = r.getResource();
        Map<RDFNode, PlaceholderInfo> placeholders = r.getPlaceholders();
        Model resolvedModel = ModelFactory.createDefaultModel();
        Resource unresolvedRoot = r.getResource();
        Resource resolvedRoot = ModelUtils.convertGraphNodeToRDFNode((Node)node, (Model)resolvedModel).asResource();
        Set<Resource> current = Collections.singleton(r.getResource());
        HashSet<Object> next = new HashSet<Resource>();
        HashSet visited = new HashSet();
        HashMap<Object, Object> resolutions = new HashMap<Object, Object>();
        resolutions.put(unresolvedRoot, resolvedRoot);
        while (!current.isEmpty()) {
            for (RDFNode rDFNode : current) {
                if (visited.contains(rDFNode) || !rDFNode.isResource()) continue;
                Resource fragS = rDFNode.asResource();
                for (Statement fragStmt : fragS.listProperties().toList()) {
                    RDFNode o;
                    Property p = fragStmt.getPredicate();
                    RDFNode fragO = fragStmt.getObject();
                    if (fragO != null && fragO.isResource()) {
                        next.add((Resource)fragO);
                    }
                    Resource s = ((RDFNode)resolutions.get(fragS)).asResource();
                    PlaceholderInfo info = placeholders.get(fragO);
                    if (info != null) {
                        Node n;
                        boolean hasDependentIdentity;
                        Object entity = info.getValue();
                        Class<?> valueClass = entity != null ? entity.getClass() : info.getTargetClass();
                        boolean reuseIri = true;
                        Statement reusedStmt = fragS.getProperty(p);
                        RDFNode reusedO = reusedStmt == null ? null : reusedStmt.getObject();
                        RdfType targetRdfType = info.getTargetRdfType();
                        RdfMapperProperty propertyMapper = info.getMapper();
                        PropertyOps pops = propertyMapper != null ? propertyMapper.getPropertyOps() : null;
                        targetRdfType = targetRdfType != null ? targetRdfType : this.typeFactory.forJavaType(valueClass);
                        boolean bl = hasDependentIdentity = !targetRdfType.isSimpleType() && !targetRdfType.hasIdentity();
                        Node node2 = propertyMapper != null && hasDependentIdentity ? propertyMapper.getTargetNode(s.getURI(), entity) : (n = entity != null ? targetRdfType.getRootNode(entity) : null);
                        if (n != null) {
                            o = ModelUtils.convertGraphNodeToRDFNode((Node)n, (Model)resolvedModel);
                            if (o.isResource()) {
                                EntityId valueEntityId = this.merge(entity, n, valueClass, targetRdfType);
                                if (hasDependentIdentity) {
                                    entityState.getDependentEntityIds().add(valueEntityId);
                                }
                            }
                        } else {
                            o = null;
                        }
                    } else {
                        o = fragO.inModel(resolvedModel);
                    }
                    if (o == null) continue;
                    resolutions.put(fragO, o);
                    s.addProperty(p, o);
                }
            }
            current = next;
            next = new HashSet();
        }
        Resource resolvedS = ((RDFNode)resolutions.get(exposedS)).asResource();
        EntityFragment entityFragment = rdfClass.populate(resolvedS, tgtEntity);
        if (entityFragment == null) {
            throw new NullPointerException("Population must not return a null fragment, Error might be in the implementation of " + rdfClass.getClass());
        }
        this.populateEntity(entityFragment);
        entityState.setCurrentResource((RDFNode)resolvedS);
        this.commit();
        EntityId result = entityId;
        return result;
    }

    public void commit() {
        DatasetDescription datasetDescription = this.sparqlService.getDatasetDescription();
        String gStr = DatasetDescriptionUtils.getSingleDefaultGraphUri((DatasetDescription)datasetDescription);
        if (gStr == null) {
            throw new RuntimeException("No target graph specified");
        }
        Node g = NodeFactory.createURI((String)gStr);
        DatasetGraph oldState = DatasetGraphFactory.create();
        DatasetGraph newState = DatasetGraphFactory.create();
        for (Map.Entry<EntityId, EntityState> e : this.originalState.entrySet()) {
            EntityState state = e.getValue();
            RDFNode current = state.getCurrentResource();
            if (current == null) continue;
            Graph oldGraph = state.getShapeResource().getModel().getGraph();
            Graph newGraph = current.getModel().getGraph();
            oldState.addGraph(g, oldGraph);
            newState.addGraph(g, newGraph);
        }
        Diff diff = UpdateDiffUtils.computeDelta((DatasetGraph)newState, (DatasetGraph)oldState);
        System.out.println("Applying diff: " + diff);
        UpdateExecutionFactory uef = this.sparqlService.getUpdateExecutionFactory();
        UpdateExecutionUtils.executeUpdate((UpdateExecutionFactory)uef, (Diff)diff);
    }

    @Override
    public RdfTypeFactory getRdfTypeFactory() {
        return this.typeFactory;
    }

    @Override
    public PathResolver createResolver(Class<?> javaClass) {
        PathFragment pathFragment = new PathFragment(Relation.empty((Var)Var.alloc((String)"root")), javaClass, null, null);
        PathResolverImpl result = new PathResolverImpl(pathFragment, this, null, null);
        return result;
    }
}

