/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.impl.type;

import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypePrimitiveBase;
import org.aksw.jena_sparql_api.mapper.model.RdfTypeFactory;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;

public class RdfTypeLiteralTyped
extends RdfTypePrimitiveBase {
    protected RDFDatatype rdfDatatype;

    public RdfTypeLiteralTyped(RdfTypeFactory typeFactory, RDFDatatype rdfDatatype) {
        this.rdfDatatype = rdfDatatype;
    }

    @Override
    public Class<?> getEntityClass() {
        return this.rdfDatatype.getJavaClass();
    }

    @Override
    public Node getRootNode(Object entity) {
        String lex = this.rdfDatatype.unparse(entity);
        Node result = NodeFactory.createLiteral((String)lex, (RDFDatatype)this.rdfDatatype);
        return result;
    }

    @Override
    public Object createJavaObject(RDFNode node) {
        if (!node.isLiteral()) {
            throw new RuntimeException("Literal node expected");
        }
        Literal literal = node.asLiteral();
        Object tmp = literal.getValue();
        String lexicalForm = this.rdfDatatype.unparse(tmp);
        Object result = this.rdfDatatype.parse(lexicalForm);
        return result;
    }

    public String toString() {
        return "RdfTypeLiteralTyped [rdfDatatype=" + this.rdfDatatype + "]";
    }

    @Override
    public boolean hasIdentity() {
        return false;
    }
}

