/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.jpa.core;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.EntityManager;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.mapper.impl.engine.RdfMapperEngineImpl;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeFactoryImpl;
import org.aksw.jena_sparql_api.mapper.jpa.core.EntityManagerImpl;
import org.aksw.jena_sparql_api.mapper.jpa.core.RdfEntityManager;
import org.aksw.jena_sparql_api.mapper.model.TypeConversionServiceImpl;
import org.aksw.jena_sparql_api.mapper.model.TypeConverterBase;
import org.aksw.jena_sparql_api.mapper.model.TypeDeciderImpl;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.expr.E_DateTimeYear;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.util.PrefixMapping2;
import org.apache.jena.vocabulary.XSD;
import org.springframework.beans.factory.FactoryBean;

public class SparqlEntityManagerFactory
implements FactoryBean<EntityManager> {
    protected Prologue prologue = new Prologue((PrefixMapping)new PrefixMapping2(PrefixMapping.Extended));
    protected Set<String> scanPackageNames = new LinkedHashSet<String>();
    protected SparqlService sparqlService;

    public Prologue getPrologue() {
        return this.prologue;
    }

    public void setSparqlService(SparqlService sparqlService) {
        this.sparqlService = sparqlService;
    }

    public PrefixMapping getPrefixMapping() {
        PrefixMapping result = this.getPrologue().getPrefixMapping();
        return result;
    }

    public Set<String> getScanPackageNames() {
        return this.scanPackageNames;
    }

    public void addScanPackageName(String packageName) {
        this.scanPackageNames.add(packageName);
    }

    public RdfEntityManager getObject() throws Exception {
        RdfMapperEngineImpl mapperEngine = new RdfMapperEngineImpl(this.sparqlService, this.prologue);
        for (String scanPackageName : this.scanPackageNames) {
            ((TypeDeciderImpl)mapperEngine.getTypeDecider()).putAll(TypeDeciderImpl.scan(scanPackageName, this.prologue));
        }
        RdfTypeFactoryImpl tf = (RdfTypeFactoryImpl)mapperEngine.getRdfTypeFactory();
        TypeConversionServiceImpl tcs = (TypeConversionServiceImpl)tf.getTypeConversionService();
        tcs.put(new TypeConverterBase(XSD.gYear.toString(), Integer.TYPE){

            @Override
            public Expr toJava(Expr expr) {
                return new E_DateTimeYear(expr);
            }

            @Override
            public Node toRdf(Object o) {
                Node node = NodeFactory.createLiteral((String)("" + o), (RDFDatatype)XSDDatatype.XSDgYear);
                return node;
            }
        });
        EntityManagerImpl result = new EntityManagerImpl(mapperEngine);
        return result;
    }

    public Class<?> getObjectType() {
        return EntityManager.class;
    }

    public boolean isSingleton() {
        return false;
    }
}

