/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.jpa.criteria;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NonUniqueResultException;
import javax.persistence.Parameter;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.aksw.jena_sparql_api.concepts.Concept;
import org.aksw.jena_sparql_api.concepts.ConceptOps;
import org.aksw.jena_sparql_api.concepts.ConceptUtils;
import org.aksw.jena_sparql_api.concepts.OrderedConcept;
import org.aksw.jena_sparql_api.core.QueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlService;
import org.aksw.jena_sparql_api.core.utils.ServiceUtils;
import org.aksw.jena_sparql_api.mapper.impl.engine.RdfMapperEngine;
import org.aksw.jena_sparql_api.mapper.impl.type.PathResolver;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.AliasMapper;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.OrderImpl;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.PathResolverVarMapper;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.expr.ExpressionCompiler;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.expr.VExpression;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.expr.VPath;
import org.aksw.jena_sparql_api.mapper.model.TypeDecider;
import org.aksw.jena_sparql_api.shape.ResourceShapeBuilder;
import org.aksw.jena_sparql_api.utils.ElementUtils;
import org.aksw.jena_sparql_api.utils.NodeTransformRenameMap;
import org.apache.jena.ext.com.google.common.collect.Iterables;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.SortCondition;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypedQueryImpl<X>
implements TypedQuery<X> {
    private static final Logger logger = LoggerFactory.getLogger(TypedQueryImpl.class);
    protected Integer startPosition = null;
    protected Integer maxResult = null;
    protected CriteriaQuery<X> criteriaQuery;
    protected RdfMapperEngine engine;
    Function<Expression<?>, String> aliasMapper = new AliasMapper();
    protected Supplier<ExpressionCompiler> expressionCompilerFactory;

    Supplier<ExpressionCompiler> createExpressionCompilerFactory() {
        return () -> {
            LinkedHashSet<Element> elements = new LinkedHashSet<Element>();
            return new ExpressionCompiler(elements, path -> this.resolvePath((VPath<?>)path, (Set<Element>)elements, this.aliasMapper));
        };
    }

    protected OrderedConcept compileConcept() {
        Concept filterConcept;
        Class resultType = this.criteriaQuery.getResultType();
        TypeDecider typeDecider = this.engine.getTypeDecider();
        ResourceShapeBuilder rsb = new ResourceShapeBuilder();
        ExpressionCompiler filterCompiler = this.expressionCompilerFactory.get();
        Set roots = this.criteriaQuery.getRoots();
        Var firstRoot = null;
        for (Root root : roots) {
            Class javaType = root.getJavaType();
            Resource r = ModelFactory.createDefaultModel().createResource();
            this.engine.getTypeDecider().writeTypeTriples(r, javaType);
            Object bp = new BasicPattern();
            r.getModel().getGraph().find(Node.ANY, Node.ANY, Node.ANY).toSet().forEach(arg_0 -> ((BasicPattern)bp).add(arg_0));
            String rootName = this.aliasMapper.apply((Expression<?>)root);
            Var rootVar = Var.alloc((String)rootName);
            firstRoot = firstRoot == null ? rootVar : firstRoot;
            bp = NodeTransformLib.transform((NodeTransform)new NodeTransformRenameMap(Collections.singletonMap(r.asNode(), rootVar)), (BasicPattern)bp);
            ElementTriplesBlock etb = new ElementTriplesBlock((BasicPattern)bp);
            filterCompiler.getElements().add((Element)etb);
        }
        VExpression filterEx = (VExpression)this.criteriaQuery.getRestriction();
        if (filterEx != null) {
            Expr expr = filterEx.accept(filterCompiler);
            filterCompiler.getElements().add((Element)new ElementFilter(expr));
        }
        if (!filterCompiler.getElements().isEmpty()) {
            Element filterEl = ElementUtils.groupIfNeeded(filterCompiler.getElements());
            filterConcept = new Concept(filterEl, firstRoot);
        } else {
            filterConcept = ConceptUtils.createSubjectConcept();
        }
        ExpressionCompiler orderCompiler = this.expressionCompilerFactory.get();
        ArrayList<SortCondition> sortConditions = new ArrayList<SortCondition>();
        for (Order order : this.criteriaQuery.getOrderList()) {
            Expression x = ((OrderImpl)order).getExpression();
            Expr e = x.accept(orderCompiler);
            int dir = order.isAscending() ? 1 : -1;
            sortConditions.add(new SortCondition(e, dir));
        }
        Element orderEl = ElementUtils.groupIfNeeded(orderCompiler.getElements());
        Concept orderC = new Concept(orderEl, firstRoot);
        OrderedConcept orderConcept = new OrderedConcept(orderC, sortConditions);
        logger.debug("Sort conditions: " + sortConditions);
        OrderedConcept result = ConceptOps.applyOrder((Concept)filterConcept, (OrderedConcept)orderConcept, null);
        return result;
    }

    public Var resolvePath(VPath<?> path, Set<Element> elements, Function<Expression<?>, String> aliasMapper) {
        Class<?> rootClass = PathResolverVarMapper.getRootClass(path);
        PathResolver rootResolver = this.engine.createResolver(rootClass);
        PathResolverVarMapper pathMapper = new PathResolverVarMapper(rootResolver, elements, aliasMapper);
        Var result = path.accept(pathMapper);
        return result;
    }

    public TypedQueryImpl(CriteriaQuery<X> criteriaQuery, RdfMapperEngine engine) {
        this.criteriaQuery = criteriaQuery;
        this.engine = engine;
        this.expressionCompilerFactory = this.createExpressionCompilerFactory();
    }

    public X getSingleResult() {
        List<X> items = this.getResultList(2);
        if (items.size() > 1) {
            throw new NonUniqueResultException();
        }
        Object result = Iterables.getFirst(items, null);
        return (X)result;
    }

    public TypedQuery<X> setMaxResults(int maxResult) {
        this.maxResult = maxResult;
        return this;
    }

    public TypedQuery<X> setFirstResult(int startPosition) {
        this.startPosition = startPosition;
        return this;
    }

    public int getMaxResults() {
        return this.maxResult;
    }

    public int getFirstResult() {
        return this.startPosition;
    }

    public int executeUpdate() {
        throw new UnsupportedOperationException();
    }

    public Map<String, Object> getHints() {
        throw new UnsupportedOperationException();
    }

    public Set<Parameter<?>> getParameters() {
        throw new UnsupportedOperationException();
    }

    public Parameter<?> getParameter(String name) {
        throw new UnsupportedOperationException();
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        throw new UnsupportedOperationException();
    }

    public Parameter<?> getParameter(int position) {
        throw new UnsupportedOperationException();
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        throw new UnsupportedOperationException();
    }

    public boolean isBound(Parameter<?> param) {
        return false;
    }

    public <T> T getParameterValue(Parameter<T> param) {
        throw new UnsupportedOperationException();
    }

    public Object getParameterValue(String name) {
        throw new UnsupportedOperationException();
    }

    public Object getParameterValue(int position) {
        throw new UnsupportedOperationException();
    }

    public FlushModeType getFlushMode() {
        throw new UnsupportedOperationException();
    }

    public LockModeType getLockMode() {
        throw new UnsupportedOperationException();
    }

    public <T> T unwrap(Class<T> cls) {
        throw new UnsupportedOperationException();
    }

    public List<X> getResultList() {
        List<X> result = this.getResultList(null);
        return result;
    }

    public List<X> getResultList(Integer limit) {
        Long l = this.maxResult != null ? Long.valueOf(this.maxResult.longValue()) : null;
        Long o = this.startPosition != null ? Long.valueOf(this.startPosition.longValue()) : null;
        SparqlService sparqlService = this.engine.getSparqlService();
        OrderedConcept orderedConcept = this.compileConcept();
        Var resultVar = orderedConcept.getConcept().getVar();
        Query query = ConceptUtils.createQueryList((OrderedConcept)orderedConcept, (Long)l, (Long)o);
        Selection selection = this.criteriaQuery.getSelection();
        if (selection != null && !(selection instanceof Root)) {
            ExpressionCompiler selectionCompiler = this.expressionCompilerFactory.get();
            VExpression e = (VExpression)selection;
            Expr expr = e.accept(selectionCompiler);
            ArrayList<Element> els = new ArrayList<Element>();
            if (!orderedConcept.getConcept().isSubjectConcept()) {
                els.add(query.getQueryPattern());
            }
            els.addAll(selectionCompiler.getElements());
            Element x = ElementUtils.groupIfNeeded(els);
            query.setQueryPattern(x);
            if (expr instanceof ExprAggregator) {
                Aggregator agg = ((ExprAggregator)expr).getAggregator();
                expr = query.allocAggregate(agg);
            }
            query.getProject().clear();
            if (selection instanceof Expression) {
                Expression selExpr = (Expression)selection;
                String varName = this.aliasMapper.apply(selExpr);
                resultVar = Var.alloc((String)varName);
                query.getProject().add(resultVar, expr);
            } else {
                query.getProject().add(resultVar, expr);
            }
        }
        logger.debug("Query: " + query);
        QueryExecutionFactory qef = sparqlService.getQueryExecutionFactory();
        List items = ServiceUtils.fetchList((QueryExecutionFactory)qef, (Query)query, (Var)resultVar);
        List result = items.stream().map(node -> {
            Class clazz = this.criteriaQuery.getResultType();
            Object r = this.engine.find(clazz, (Node)node);
            return r;
        }).collect(Collectors.toList());
        logger.debug("GOT " + items + " for concept" + query);
        return result;
    }

    public TypedQuery<X> setHint(String hintName, Object value) {
        throw new UnsupportedOperationException();
    }

    public <T> TypedQuery<X> setParameter(Parameter<T> param, T value) {
        throw new UnsupportedOperationException();
    }

    public TypedQuery<X> setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        throw new UnsupportedOperationException();
    }

    public TypedQuery<X> setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        throw new UnsupportedOperationException();
    }

    public TypedQuery<X> setParameter(String name, Object value) {
        throw new UnsupportedOperationException();
    }

    public TypedQuery<X> setParameter(String name, Calendar value, TemporalType temporalType) {
        throw new UnsupportedOperationException();
    }

    public TypedQuery<X> setParameter(String name, Date value, TemporalType temporalType) {
        throw new UnsupportedOperationException();
    }

    public TypedQuery<X> setParameter(int position, Object value) {
        throw new UnsupportedOperationException();
    }

    public TypedQuery<X> setParameter(int position, Calendar value, TemporalType temporalType) {
        throw new UnsupportedOperationException();
    }

    public TypedQuery<X> setParameter(int position, Date value, TemporalType temporalType) {
        throw new UnsupportedOperationException();
    }

    public TypedQuery<X> setFlushMode(FlushModeType flushMode) {
        throw new UnsupportedOperationException();
    }

    public TypedQuery<X> setLockMode(LockModeType lockMode) {
        throw new UnsupportedOperationException();
    }
}

