/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.jpa.criteria.expr;

import java.util.Collection;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.expr.AvgExpression;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.expr.BinaryOperatorExpression;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.expr.EqualsExpression;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.expr.ExpressionVisitor;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.expr.GreaterThanExpression;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.expr.GreaterThanOrEqualToExpression;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.expr.GreatestExpression;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.expr.LogicalAndExpression;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.expr.LogicalNotExpression;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.expr.VPath;
import org.aksw.jena_sparql_api.mapper.jpa.criteria.expr.ValueExpression;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_GreaterThan;
import org.apache.jena.sparql.expr.E_GreaterThanOrEqual;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.AggAvg;
import org.apache.jena.sparql.expr.aggregate.AggMax;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.syntax.Element;

public class ExpressionCompiler
implements ExpressionVisitor<Expr> {
    protected TypeMapper typeMapper;
    protected Function<VPath<?>, Var> pathHandler;
    protected Collection<Element> elements;

    public Collection<Element> getElements() {
        return this.elements;
    }

    public ExpressionCompiler(Collection<Element> elements, Function<VPath<?>, Var> pathHandler) {
        this.elements = elements;
        this.pathHandler = pathHandler;
        this.typeMapper = TypeMapper.getInstance();
    }

    @Override
    public Expr visit(VPath<?> e) {
        Var var = this.pathHandler.apply(e);
        ExprVar result = new ExprVar(var);
        return result;
    }

    @Override
    public Expr visit(LogicalAndExpression e) {
        Expr result = this.appendExpr(e, (a, b) -> new E_LogicalAnd(a, b));
        return result;
    }

    @Override
    public Expr visit(EqualsExpression e) {
        Expr result = this.appendExpr(e, (a, b) -> new E_Equals(a, b));
        return result;
    }

    @Override
    public Expr visit(GreaterThanExpression e) {
        Expr result = this.appendExpr(e, (a, b) -> new E_GreaterThan(a, b));
        return result;
    }

    @Override
    public Expr visit(GreaterThanOrEqualToExpression e) {
        Expr result = this.appendExpr(e, (a, b) -> new E_GreaterThanOrEqual(a, b));
        return result;
    }

    public Expr appendExpr(BinaryOperatorExpression<Boolean> e, BiFunction<Expr, Expr, Expr> op) {
        Expr a = e.getLeftHandOperand().accept(this);
        Expr b = e.getRightHandOperand().accept(this);
        Expr result = op.apply(a, b);
        return result;
    }

    @Override
    public Expr visit(LogicalNotExpression e) {
        Expr a = e.accept(this);
        E_LogicalNot result = new E_LogicalNot(a);
        return result;
    }

    @Override
    public Expr visit(GreatestExpression<?> e) {
        Expr expr = e.getOperand().accept(this);
        AggMax agg = new AggMax(expr);
        ExprAggregator result = new ExprAggregator(Vars.x, (Aggregator)agg);
        return result;
    }

    @Override
    public Expr visit(AvgExpression e) {
        Expr expr = e.getOperand().accept(this);
        AggAvg agg = new AggAvg(expr);
        ExprAggregator result = new ExprAggregator(Vars.x, (Aggregator)agg);
        return result;
    }

    @Override
    public Expr visit(ValueExpression<?> e) {
        Object value = e.getValue();
        RDFDatatype rdfDatatype = this.typeMapper.getTypeByValue(value);
        Node node = NodeFactory.createLiteralByValue(value, (RDFDatatype)rdfDatatype);
        NodeValue result = NodeValue.makeNode((Node)node);
        return result;
    }
}

