/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.jpa.metamodel;

import java.awt.List;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import org.aksw.jena_sparql_api.beans.model.EntityOps;
import org.aksw.jena_sparql_api.beans.model.PropertyOps;

public class MetamodelGenerator {
    protected Function<Class<?>, EntityOps> entityOpsGenerator;

    public MetamodelGenerator(Function<Class<?>, EntityOps> entityOpsGenerator) {
        this.entityOpsGenerator = entityOpsGenerator;
    }

    public <X> EntityType<X> apply(Class<X> cls) {
        EntityOps entityOps = this.entityOpsGenerator.apply(cls);
        if (!entityOps.isPrimitive()) {
            for (PropertyOps propertyOps : entityOps.getProperties()) {
                this.createAttribute(cls, propertyOps);
            }
        }
        return null;
    }

    public <X> Attribute<X, ?> createAttribute(Class<X> cls, PropertyOps pop) {
        Type[] types;
        Class<?> attrCls = pop.getType();
        String attributeName = pop.getName();
        System.out.println("Analysing attribute " + attributeName);
        Method m = pop.getReadMethod();
        Type type = m != null ? m.getGenericReturnType() : null;
        ParameterizedType p = type instanceof ParameterizedType ? (ParameterizedType)type : null;
        Type[] typeArray = types = p != null ? p.getActualTypeArguments() : new Type[]{};
        if (Collection.class.isAssignableFrom(attrCls)) {
            Class itemClass;
            Class clazz = itemClass = types != null && types.length >= 1 ? (Class)types[0] : null;
            if (List.class.isAssignableFrom(attrCls) || Set.class.isAssignableFrom(attrCls)) {
                // empty if block
            }
            System.out.println(itemClass);
        } else if (Map.class.isAssignableFrom(attrCls)) {
            Class keyClass = types != null && types.length >= 2 ? (Class)types[0] : null;
            Class valueClass = types != null && types.length >= 2 ? (Class)types[1] : null;
            System.out.println(keyClass + " -> " + valueClass);
        } else {
            System.out.println(attrCls);
        }
        return null;
    }
}

