/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.model;

import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;
import org.aksw.jena_sparql_api.beans.model.PropertyOps;
import org.aksw.jena_sparql_api.mapper.model.RdfMapperProperty;
import org.aksw.jena_sparql_api.mapper.model.RdfType;
import org.aksw.jena_sparql_api.mapper.model.TypeConverter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Property;
import org.h2.util.StringUtils;

public abstract class RdfMapperPropertyBase
implements RdfMapperProperty {
    protected PropertyOps propertyOps;
    protected Property predicate;
    protected RdfType targetRdfType;
    protected transient Set<String> propertyNames;
    protected BiFunction<Object, Object, Node> createTargetNode;
    protected TypeConverter typeConverter;

    public RdfMapperPropertyBase(PropertyOps propertyOps, Property predicate, RdfType targetRdfType, BiFunction<Object, Object, Node> createTargetNode, TypeConverter typeConverter) {
        this.propertyOps = propertyOps;
        this.predicate = predicate;
        this.targetRdfType = targetRdfType;
        this.propertyNames = Collections.singleton(propertyOps.getName());
        this.createTargetNode = createTargetNode;
        this.typeConverter = typeConverter;
    }

    @Override
    public PropertyOps getPropertyOps() {
        return this.propertyOps;
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Node getTargetNode(String subjectUri, Object entity) {
        Node result = this.targetRdfType.hasIdentity() ? this.targetRdfType.getRootNode(entity) : NodeFactory.createURI((String)(subjectUri + "-" + StringUtils.urlEncode((String)this.propertyOps.getName())));
        return result;
    }
}

