/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.model;

import com.google.common.base.Defaults;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import org.aksw.jena_sparql_api.beans.model.PropertyOps;
import org.aksw.jena_sparql_api.concepts.Relation;
import org.aksw.jena_sparql_api.concepts.RelationUtils;
import org.aksw.jena_sparql_api.mapper.impl.type.EntityFragment;
import org.aksw.jena_sparql_api.mapper.impl.type.PathFragment;
import org.aksw.jena_sparql_api.mapper.impl.type.PlaceholderInfo;
import org.aksw.jena_sparql_api.mapper.impl.type.ResolutionTask;
import org.aksw.jena_sparql_api.mapper.impl.type.ResourceFragment;
import org.aksw.jena_sparql_api.mapper.model.RdfMapperPropertyBase;
import org.aksw.jena_sparql_api.mapper.model.RdfType;
import org.aksw.jena_sparql_api.mapper.model.TypeConverter;
import org.aksw.jena_sparql_api.shape.ResourceShapeBuilder;
import org.aksw.jena_sparql_api.utils.ElementUtils;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementGroup;

public class RdfMapperPropertySingle
extends RdfMapperPropertyBase {
    public RdfMapperPropertySingle(PropertyOps propertyOps, Property predicate, RdfType targetRdfType, BiFunction<Object, Object, Node> createTargetIri, TypeConverter typeConverter) {
        super(propertyOps, predicate, targetRdfType, createTargetIri, typeConverter);
    }

    @Override
    public void exposeFragment(ResourceFragment out, Resource priorState, Object entity) {
        Resource s = out.getResource();
        Model tmp = s.getModel();
        Resource o = tmp.createResource();
        Object v = this.propertyOps.getValue(entity);
        s.addProperty(this.predicate, (RDFNode)o);
        PlaceholderInfo info = new PlaceholderInfo(null, this.targetRdfType, entity, null, this.propertyOps, v, null, this);
        out.getPlaceholders().put((RDFNode)o, info);
    }

    @Override
    public void populate(EntityFragment out, Resource shape, final Object entity) {
        Statement stmt = shape.getProperty(this.predicate);
        RDFNode o = stmt == null ? null : stmt.getObject();
        final List<PlaceholderInfo> pis = Arrays.asList(new PlaceholderInfo(null, this.targetRdfType, entity, null, this.propertyOps, null, o, this));
        out.getTasks().add(new ResolutionTask<PlaceholderInfo>(){

            @Override
            public List<PlaceholderInfo> getPlaceholders() {
                return pis;
            }

            @Override
            public Collection<ResolutionTask<PlaceholderInfo>> resolve(List<Object> resolutions) {
                Object value = resolutions.get(0);
                Class<?> propertyClass = RdfMapperPropertySingle.this.propertyOps.getType();
                if (value == null) {
                    value = Defaults.defaultValue(propertyClass);
                }
                RdfMapperPropertySingle.this.propertyOps.setValue(entity, value);
                return Collections.emptyList();
            }
        });
    }

    @Override
    public void exposeShape(ResourceShapeBuilder shapeBuilder) {
        shapeBuilder.out(this.predicate);
    }

    public String toString() {
        return "RdfPopulatorPropertySingle [propertyName=" + this.propertyOps.getName() + ", predicate=" + this.predicate + ", targetRdfType=" + this.targetRdfType + "]";
    }

    @Override
    public PropertyOps getPropertyOps() {
        return this.propertyOps;
    }

    @Override
    public PathFragment resolve(String propertyName) {
        PathFragment result = null;
        boolean isMatchingProperty = this.propertyOps.getName().equals(propertyName);
        if (isMatchingProperty) {
            Relation relation;
            if (this.typeConverter == null) {
                relation = RelationUtils.createRelation((Node)this.predicate.asNode(), (boolean)false);
            } else {
                ElementGroup group = new ElementGroup();
                group.addElement((Element)ElementUtils.createElement((Triple)new Triple((Node)Vars.s, this.predicate.asNode(), (Node)Vars.x)));
                Expr expr = this.typeConverter.toJava((Expr)new ExprVar(Vars.x));
                group.addElement((Element)new ElementBind(Vars.o, expr));
                relation = new Relation((Element)group, Vars.s, Vars.o);
            }
            result = new PathFragment(relation, this.propertyOps.getType(), this.targetRdfType, null);
        }
        return result;
    }
}

