/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.mapper.trash;

import java.util.List;
import org.aksw.jena_sparql_api.mapper.trash.RdfValueMapper;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphUtil;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;

public class RdfValueMapperSimple
implements RdfValueMapper {
    protected Class<?> propertyType;
    protected RDFDatatype dtype;
    protected Node nullValue;

    public RdfValueMapperSimple(Class<?> propertyType, RDFDatatype dtype, Node nullValue) {
        this.propertyType = propertyType;
        this.dtype = dtype;
        this.nullValue = nullValue;
    }

    @Override
    public void writeValue(Object value, Node subject, Node predicate, Graph outputGraph) {
        Node o;
        if (value != null) {
            Class<?> valueType = value.getClass();
            boolean isValidType = this.propertyType.isAssignableFrom(valueType);
            if (!isValidType) {
                throw new RuntimeException("Invalid object provided");
            }
            String lex = this.dtype.unparse(value);
            o = NodeFactory.createLiteral((String)lex, (RDFDatatype)this.dtype);
        } else {
            o = this.nullValue;
        }
        if (o != null) {
            Triple triple = new Triple(subject, predicate, o);
            outputGraph.add(triple);
        }
    }

    @Override
    public Object readValue(Graph graph, Node subject, Node predicate) {
        Node node;
        List nodes = GraphUtil.listObjects((Graph)graph, (Node)subject, (Node)predicate).toList();
        Object result = null;
        if (!nodes.isEmpty() && (node = (Node)nodes.iterator().next()) != null) {
            result = node.equals((Object)this.nullValue) ? null : node.getLiteralValue();
        }
        return result;
    }
}

