/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.shape;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import org.aksw.gson.utils.JsonVisitor;
import org.aksw.gson.utils.JsonWalker;
import org.aksw.jena_sparql_api.concepts.BinaryRelation;
import org.aksw.jena_sparql_api.concepts.BinaryRelationImpl;
import org.aksw.jena_sparql_api.shape.ResourceShape;
import org.aksw.jena_sparql_api.shape.ResourceShapeBuilder;
import org.aksw.jena_sparql_api.shape.StepRelation;
import org.aksw.jena_sparql_api.utils.Vars;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.shared.impl.PrefixMappingImpl;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.util.ExprUtils;

public class ResourceShapeParserJson
implements JsonVisitor<Void> {
    protected ResourceShapeBuilder builder;

    public ResourceShapeBuilder getBuilder() {
        return this.builder;
    }

    public ResourceShapeParserJson() {
        this((PrefixMapping)new PrefixMappingImpl());
    }

    public ResourceShapeParserJson(PrefixMapping prefixMapping) {
        this(new ResourceShapeBuilder(prefixMapping));
    }

    public ResourceShapeParserJson(Prologue prologue) {
        this(new ResourceShapeBuilder(prologue));
    }

    public ResourceShapeParserJson(ResourceShapeBuilder builder) {
        this.builder = builder;
    }

    public static StepRelation parseStep(String str, PrefixMapping prefixMapping) {
        Expr expr;
        boolean isExpr;
        boolean isInverse;
        char c = (str = str.trim()).charAt(0);
        boolean bl = isInverse = c == '-';
        if (isInverse) {
            str = str.substring(1);
        }
        boolean bl2 = isExpr = (c = str.charAt(0)) == '~';
        if (isExpr) {
            str = str.substring(1);
        }
        if (isExpr) {
            expr = ExprUtils.parse((String)str, (PrefixMapping)prefixMapping);
        } else {
            String p = prefixMapping.expandPrefix(str);
            Node np = NodeFactory.createURI((String)p);
            expr = new E_Equals((Expr)new ExprVar(Vars.p), (Expr)NodeValue.makeNode((Node)np));
        }
        BinaryRelationImpl relation = new BinaryRelationImpl((Element)new ElementFilter(expr), Vars.p, Vars.o);
        StepRelation result = new StepRelation((BinaryRelation)relation, isInverse);
        return result;
    }

    public static ResourceShape parse(JsonElement json) {
        ResourceShapeParserJson parser = new ResourceShapeParserJson();
        JsonWalker.visit((JsonElement)json, (JsonVisitor)parser);
        ResourceShape result = parser.getBuilder().getResourceShape();
        return result;
    }

    public static ResourceShape parse(JsonElement json, ResourceShapeBuilder builder) {
        ResourceShapeParserJson parser = new ResourceShapeParserJson(builder);
        JsonWalker.visit((JsonElement)json, (JsonVisitor)parser);
        ResourceShape result = builder.getResourceShape();
        return result;
    }

    public Void visit(JsonNull json) {
        return null;
    }

    public Void visit(JsonObject json) {
        PrefixMapping pm = this.builder.getPrefixMapping();
        for (Map.Entry entry : json.entrySet()) {
            String str = (String)entry.getKey();
            JsonElement e = (JsonElement)entry.getValue();
            StepRelation step = ResourceShapeParserJson.parseStep(str, pm);
            ResourceShapeBuilder subBilder = this.builder.nav(step);
            JsonWalker.visit((JsonElement)e, (JsonVisitor)this);
            ResourceShapeParserJson.parse(e, subBilder);
        }
        return null;
    }

    public Void visit(JsonArray json) {
        for (JsonElement item : json) {
            JsonWalker.walk((JsonElement)item, (JsonVisitor)this);
        }
        return null;
    }

    public Void visit(JsonPrimitive json) {
        PrefixMapping pm = this.builder.getPrefixMapping();
        if (json.isBoolean()) {
            Boolean tf = json.getAsBoolean();
            if (tf.booleanValue()) {
                this.builder.nav((Expr)NodeValue.TRUE, true);
            }
        } else if (json.isString()) {
            String str = json.getAsString();
            StepRelation step = ResourceShapeParserJson.parseStep(str, pm);
            this.builder.nav(step);
        }
        return null;
    }
}

