/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.normal_form;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.normal_form.Clause;
import org.apache.commons.collections.CollectionUtils;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;

public abstract class ExprNormalForm {
    protected Multimap<Var, Clause> varToClauses = HashMultimap.create();
    protected Multimap<Set<Var>, Clause> varsToClauses = HashMultimap.create();
    protected Multimap<Expr, Clause> exprToClauses = HashMultimap.create();
    protected Set<Expr> commonExprs = new HashSet<Expr>();
    protected Set<Var> varsMentioned = new HashSet<Var>();

    public Set<Clause> filterByVars(Set<Var> requiredVars) {
        HashSet<Clause> result = new HashSet<Clause>();
        for (Map.Entry entry : this.varsToClauses.asMap().entrySet()) {
            Set clauseVars = (Set)entry.getKey();
            if (!clauseVars.containsAll(requiredVars)) continue;
            result.addAll((Collection)entry.getValue());
        }
        return result;
    }

    public ExprNormalForm(Collection<Clause> clauses) {
        this.addAll(clauses);
    }

    private void addAll(Collection<Clause> clauses) {
        for (Clause clause : clauses) {
            this.add(clause);
        }
    }

    private boolean add(Clause clause) {
        Set<Var> vars = clause.getVarsMentioned();
        if (this.varsToClauses.put(vars, (Object)clause)) {
            for (Var var : vars) {
                this.varToClauses.put((Object)var, (Object)clause);
            }
            this.varsMentioned.addAll(vars);
            if (this.exprToClauses.isEmpty()) {
                this.commonExprs.addAll(clause.getExprs());
            } else {
                this.commonExprs.retainAll(clause.getExprs());
            }
            for (Expr expr : clause.getExprs()) {
                this.exprToClauses.put((Object)expr, (Object)clause);
            }
            return true;
        }
        return false;
    }

    public Collection<Clause> getExactly(Set<Var> vars) {
        return this.varsToClauses.get(vars);
    }

    public Set<Clause> get(Collection<Var> vars) {
        HashSet<Clause> result = new HashSet<Clause>();
        float scanFactor = 0.75f;
        Collection values = this.varsToClauses.values();
        if ((float)vars.size() > scanFactor * (float)values.size()) {
            for (Clause clause : values) {
                if (!CollectionUtils.containsAny(clause.getVarsMentioned(), vars)) continue;
                result.add(clause);
            }
        } else {
            for (Var var : vars) {
                result.addAll(this.varToClauses.get((Object)var));
            }
        }
        return result;
    }

    public Collection<Clause> get(Var var) {
        return this.varToClauses.get((Object)var);
    }

    public Collection<Clause> getClauses() {
        return this.varsToClauses.values();
    }

    public String toString() {
        return this.varsToClauses.values().toString();
    }

    public Set<Expr> getCommonExprs() {
        return this.commonExprs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.varsToClauses == null ? 0 : this.varsToClauses.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExprNormalForm other = (ExprNormalForm)obj;
        return !(this.varsToClauses == null ? other.varsToClauses != null : !this.varsToClauses.equals(other.varsToClauses));
    }

    public int size() {
        return this.varsToClauses.size();
    }

    public Set<Var> getVarsMentioned() {
        return this.varsMentioned;
    }
}

