/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.aksw.jena_sparql_api.views.Dialect;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.SortCondition;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.ARQNotImplemented;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpConditional;
import org.apache.jena.sparql.algebra.op.OpDatasetNames;
import org.apache.jena.sparql.algebra.op.OpDiff;
import org.apache.jena.sparql.algebra.op.OpDisjunction;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLabel;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpList;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpPath;
import org.apache.jena.sparql.algebra.op.OpProcedure;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpPropFunc;
import org.apache.jena.sparql.algebra.op.OpQuad;
import org.apache.jena.sparql.algebra.op.OpQuadBlock;
import org.apache.jena.sparql.algebra.op.OpQuadPattern;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpTopN;
import org.apache.jena.sparql.algebra.op.OpTriple;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementAssign;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.util.graph.GraphList;
import org.apache.jena.vocabulary.RDF;

public class MyOpAsQuery {
    public static Query asQuery(Op op) {
        return MyOpAsQuery.asQuery(op, Dialect.DEFAULT);
    }

    public static Query asQuery(Op op, Dialect dialect) {
        Query query = QueryFactory.make();
        Converter v = new Converter(query, dialect);
        op.visit((OpVisitor)v);
        List vars = v.projectVars;
        query.setQueryResultStar(vars.isEmpty());
        for (Var var : vars) {
            if (v.varExpression.containsKey(var)) {
                query.addResultVar((Node)var, (Expr)v.varExpression.get(var));
                continue;
            }
            query.addResultVar((Node)var);
        }
        ElementGroup eg = v.currentGroup;
        query.setQueryPattern((Element)eg);
        query.setQuerySelectType();
        query.setResultVars();
        return query;
    }

    public static class SubExprForVar
    extends ExprTransformCopy {
        private final Map<Var, Expr> varExpr;
        private boolean subOccurred = false;

        public SubExprForVar(Map<Var, Expr> varExpr) {
            this.varExpr = varExpr;
        }

        public boolean didChange() {
            return this.subOccurred;
        }

        public Expr transform(ExprVar var) {
            if (this.varExpr.containsKey(var.asVar())) {
                this.subOccurred = true;
                return this.varExpr.get(var.asVar()).deepCopy();
            }
            return var.deepCopy();
        }
    }

    public static class Converter
    implements OpVisitor {
        private Query query;
        private Element element = null;
        private ElementGroup currentGroup = null;
        private Stack<ElementGroup> stack = new Stack();
        private List<Var> projectVars = Collections.emptyList();
        private Map<Var, Expr> varExpression = new HashMap<Var, Expr>();
        private Dialect dialect;

        public Converter(Query query, Dialect dialect) {
            this.dialect = dialect;
            this.query = query;
            this.currentGroup = new ElementGroup();
        }

        Element asElement(Op op) {
            ElementGroup g = this.asElementGroup(op);
            if (g.getElements().size() == 1) {
                return (Element)g.getElements().get(0);
            }
            return g;
        }

        ElementGroup asElementGroup(Op op) {
            this.startSubGroup();
            op.visit((OpVisitor)this);
            return this.endSubGroup();
        }

        public void visit(OpBGP opBGP) {
            this.currentGroup().addElement(this.process(opBGP.getPattern()));
        }

        public void visit(OpTriple opTriple) {
            this.currentGroup().addElement((Element)this.process(opTriple.getTriple()));
        }

        public void visit(OpQuad opQuad) {
            throw new ARQNotImplemented("OpQuad");
        }

        public void visit(OpProcedure opProcedure) {
            throw new ARQNotImplemented("OpProcedure");
        }

        public void visit(OpPropFunc opPropFunc) {
            Node s = this.processPropFuncArg(opPropFunc.getSubjectArgs());
            Node o = this.processPropFuncArg(opPropFunc.getObjectArgs());
            Triple t = new Triple(s, opPropFunc.getProperty(), o);
            this.currentGroup().addElement((Element)this.process(t));
        }

        private Node processPropFuncArg(PropFuncArg args) {
            if (args.isNode()) {
                return args.getArg();
            }
            List list = args.getArgList();
            if (list.size() == 0) {
                return RDF.Nodes.nil;
            }
            BasicPattern bgp = new BasicPattern();
            Node head = GraphList.listToTriples((List)list, (BasicPattern)bgp);
            this.currentGroup().addElement(this.process(bgp));
            return head;
        }

        public void visit(OpSequence opSequence) {
            boolean nestGroup;
            ElementGroup g = this.currentGroup();
            boolean bl = nestGroup = !g.isEmpty();
            if (nestGroup) {
                this.startSubGroup();
                g = this.currentGroup();
            }
            for (Op op : opSequence) {
                Element e = this.asElement(op);
                g.addElement(e);
            }
            if (nestGroup) {
                this.endSubGroup();
            }
        }

        public void visit(OpDisjunction opDisjunction) {
            if (opDisjunction.getElements().isEmpty()) {
                return;
            }
            Op a = null;
            for (Op b : opDisjunction.getElements()) {
                if (a == null) {
                    a = b;
                    continue;
                }
                a = new OpUnion(a, b);
            }
            a.visit((OpVisitor)this);
        }

        private Element process(BasicPattern pattern) {
            if (this.query.getSyntax() == Syntax.syntaxSPARQL_10) {
                ElementTriplesBlock e = new ElementTriplesBlock();
                for (Triple t : pattern) {
                    e.addTriple(t);
                }
                return e;
            }
            if (this.query.getSyntax() == Syntax.syntaxSPARQL_11 || this.query.getSyntax() == Syntax.syntaxARQ) {
                ElementPathBlock e = new ElementPathBlock();
                for (Triple t : pattern) {
                    e.addTriple(t);
                }
                return e;
            }
            throw new ARQInternalErrorException("Unrecognized syntax: " + this.query.getSyntax());
        }

        private ElementTriplesBlock process(Triple triple) {
            ElementTriplesBlock e = new ElementTriplesBlock();
            e.addTriple(triple);
            return e;
        }

        public void visit(OpQuadPattern quadPattern) {
            BasicPattern pattern = quadPattern.getBasicPattern();
            if (!Quad.isDefaultGraph((Node)quadPattern.getGraphNode())) {
                OpGraph opGraph = new OpGraph(quadPattern.getGraphNode(), (Op)new OpBGP(pattern));
                this.visit(opGraph);
            } else {
                this.currentGroup().addElement(this.process(pattern));
            }
        }

        public void visit(OpPath opPath) {
            throw new ARQNotImplemented("OpPath");
        }

        public void visit(OpJoin opJoin) {
            Element eLeft = this.asElement(opJoin.getLeft());
            ElementGroup eRight = this.asElementGroup(opJoin.getRight());
            ElementGroup g = this.currentGroup();
            g.addElement(eLeft);
            g.addElement((Element)eRight);
        }

        private static boolean emptyGroup(Element element) {
            if (!(element instanceof ElementGroup)) {
                return false;
            }
            ElementGroup eg = (ElementGroup)element;
            return eg.isEmpty();
        }

        public void visit(OpLeftJoin opLeftJoin) {
            Element eLeft = this.asElement(opLeftJoin.getLeft());
            ElementGroup eRight = this.asElementGroup(opLeftJoin.getRight());
            if (opLeftJoin.getExprs() != null) {
                for (Expr expr : opLeftJoin.getExprs()) {
                    ElementFilter f = new ElementFilter(expr);
                    eRight.addElement((Element)f);
                }
            }
            ElementGroup g = this.currentGroup();
            if (!Converter.emptyGroup(eLeft)) {
                g.addElement(eLeft);
            }
            ElementOptional opt = new ElementOptional((Element)eRight);
            g.addElement((Element)opt);
        }

        public void visit(OpDiff opDiff) {
            throw new ARQNotImplemented("OpDiff");
        }

        public void visit(OpMinus opMinus) {
            throw new ARQNotImplemented("OpMinus");
        }

        public void visit(OpUnion opUnion) {
            ElementGroup eLeft = this.asElementGroup(opUnion.getLeft());
            ElementGroup eRight = this.asElementGroup(opUnion.getRight());
            if (eLeft instanceof ElementUnion) {
                ElementUnion elUnion = (ElementUnion)eLeft;
                elUnion.addElement((Element)eRight);
                return;
            }
            ElementUnion elUnion = new ElementUnion();
            elUnion.addElement((Element)eLeft);
            elUnion.addElement((Element)eRight);
            this.currentGroup().addElement((Element)elUnion);
        }

        public void visit(OpConditional opCondition) {
            throw new ARQNotImplemented("OpCondition");
        }

        public void visit(OpFilter opFilter) {
            Element e = this.asElement(opFilter.getSubOp());
            if (this.currentGroup() != e) {
                this.currentGroup().addElement(e);
            }
            this.element = this.currentGroup();
            ExprList exprs = opFilter.getExprs();
            for (Expr expr : exprs) {
                ElementFilter f = new ElementFilter(expr);
                this.currentGroup().addElement((Element)f);
            }
        }

        public void visit(OpGraph opGraph) {
            this.startSubGroup();
            Element e = this.asElement(opGraph.getSubOp());
            ElementGroup g = this.endSubGroup();
            ElementNamedGraph graphElt = new ElementNamedGraph(opGraph.getNode(), e);
            this.currentGroup().addElement((Element)graphElt);
        }

        public void visit(OpService opService) {
            Op op = opService.getSubOp();
            Element x = this.asElement(opService.getSubOp());
            ElementService elt = new ElementService(opService.getService(), x, opService.getSilent());
            this.currentGroup().addElement((Element)elt);
        }

        public void visit(OpDatasetNames dsNames) {
            throw new ARQNotImplemented("OpDatasetNames");
        }

        public void visit(OpTable opTable) {
            if (opTable.isJoinIdentity()) {
                return;
            }
            throw new ARQNotImplemented("OpTable");
        }

        public void visit(OpExt opExt) {
            Op op = opExt.effectiveOp();
            if (op == null) {
                throw new RuntimeException("Effective Op is null for: " + opExt.getClass());
            }
            op.visit((OpVisitor)this);
        }

        public void visit(OpNull opNull) {
            throw new ARQNotImplemented("OpNull");
        }

        public void visit(OpLabel opLabel) {
            if (opLabel.hasSubOp()) {
                opLabel.getSubOp().visit((OpVisitor)this);
            }
        }

        public void visit(OpAssign opAssign) {
            opAssign.getSubOp().visit((OpVisitor)this);
            for (Var v : opAssign.getVarExprList().getVars()) {
                Expr e = opAssign.getVarExprList().getExpr(v);
                SubExprForVar sefr = new SubExprForVar(this.varExpression);
                Expr tr = ExprTransformer.transform((ExprTransform)sefr, (Expr)e);
                if (this.inTopLevel()) {
                    this.varExpression.put(v, tr);
                    continue;
                }
                ElementAssign elt = new ElementAssign(v, e);
                ElementGroup g = this.currentGroup();
                g.addElement((Element)elt);
            }
        }

        public void visit(OpExtend opExtend) {
            if (!this.inTopLevel() && this.dialect.equals((Object)Dialect.VIRTUOSO)) {
                HashSet vars = new HashSet(OpVars.mentionedVars((Op)opExtend));
                OpProject project = new OpProject((Op)opExtend, new ArrayList(vars));
                Query query = MyOpAsQuery.asQuery((Op)project, this.dialect);
                ElementSubQuery elt = new ElementSubQuery(query);
                ElementGroup g = this.currentGroup();
                g.addElement((Element)elt);
                return;
            }
            opExtend.getSubOp().visit((OpVisitor)this);
            for (Var v : opExtend.getVarExprList().getVars()) {
                Expr e = opExtend.getVarExprList().getExpr(v);
                Expr tr = ExprTransformer.transform((ExprTransform)new SubExprForVar(this.varExpression), (Expr)e);
                if (this.inTopLevel()) {
                    this.varExpression.put(v, tr);
                    continue;
                }
                ElementBind elt = new ElementBind(v, tr);
                ElementGroup g = this.currentGroup();
                g.addElement((Element)elt);
            }
        }

        public void visit(OpList opList) {
        }

        public void visit(OpOrder opOrder) {
            List x = opOrder.getConditions();
            for (SortCondition sc : x) {
                this.query.addOrderBy(sc);
            }
            opOrder.getSubOp().visit((OpVisitor)this);
        }

        public void visit(OpProject opProject) {
            this.projectVars = opProject.getVars();
            opProject.getSubOp().visit((OpVisitor)this);
        }

        public void visit(OpReduced opReduced) {
            this.query.setReduced(true);
            opReduced.getSubOp().visit((OpVisitor)this);
        }

        public void visit(OpDistinct opDistinct) {
            this.query.setDistinct(true);
            opDistinct.getSubOp().visit((OpVisitor)this);
        }

        public void visit(OpSlice opSlice) {
            if (opSlice.getStart() != Long.MIN_VALUE) {
                this.query.setOffset(opSlice.getStart());
            }
            if (opSlice.getLength() != Long.MIN_VALUE) {
                this.query.setLimit(opSlice.getLength());
            }
            opSlice.getSubOp().visit((OpVisitor)this);
        }

        public void visit(OpGroup opGroup) {
            List a = opGroup.getAggregators();
            for (ExprAggregator ea : a) {
                Var givenVar = ea.getAggVar().asVar();
                Expr myAggr = this.query.allocAggregate(ea.getAggregator());
                this.varExpression.put(givenVar, myAggr);
            }
            VarExprList b = opGroup.getGroupVars();
            for (Var v : b.getVars()) {
                Expr e = b.getExpr(v);
                if (e != null) {
                    this.query.addGroupBy(v, e);
                    continue;
                }
                this.query.addGroupBy((Node)v);
            }
            opGroup.getSubOp().visit((OpVisitor)this);
        }

        public void visit(OpTopN opTop) {
            throw new ARQNotImplemented("OpTopN");
        }

        private Element lastElement() {
            ElementGroup g = this.currentGroup;
            if (g == null || g.getElements().size() == 0) {
                return null;
            }
            int len = g.getElements().size();
            return (Element)g.getElements().get(len - 1);
        }

        private void startSubGroup() {
            ElementGroup g;
            this.push(this.currentGroup);
            this.currentGroup = g = new ElementGroup();
        }

        private ElementGroup endSubGroup() {
            ElementGroup g = this.pop();
            ElementGroup r = this.currentGroup;
            this.currentGroup = g;
            return r;
        }

        private ElementGroup currentGroup() {
            return this.currentGroup;
        }

        private ElementGroup peek() {
            if (this.stack.size() == 0) {
                return null;
            }
            return this.stack.peek();
        }

        private ElementGroup pop() {
            return this.stack.pop();
        }

        private void push(ElementGroup el) {
            this.stack.push(el);
        }

        private boolean inTopLevel() {
            return this.stack.size() == 0;
        }

        public void visit(OpQuadBlock op) {
            throw new RuntimeException("Not implemented");
        }
    }
}

