/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.views;

import java.util.Arrays;
import org.aksw.commons.util.reflect.MultiMethod;
import org.aksw.jena_sparql_api.views.E_RdfTerm;
import org.apache.jena.sparql.expr.E_Function;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;

public class SparqlSubstitute {
    public static Expr substituteExpr(Expr expr) {
        return (Expr)MultiMethod.invokeStatic(SparqlSubstitute.class, (String)"substitute", (Object[])new Object[]{expr});
    }

    public static Expr substitute(Expr expr) {
        return expr;
    }

    public static ExprList makeExprList(Expr ... exprs) {
        return new ExprList(Arrays.asList(exprs));
    }

    public static Expr substitute(E_Function expr) {
        if (expr.getFunctionIRI().equals("http://aksw.org/sparqlify/rdfTerm")) {
            if (expr.getArgs().size() != 4) {
                throw new RuntimeException("RdfTerm requires 4 arguments, instead got: " + expr);
            }
            return new E_RdfTerm(expr.getArg(1), expr.getArg(2), expr.getArg(3), expr.getArg(4));
        }
        if (expr.getFunctionIRI().equals("http://aksw.org/sparqlify/uri")) {
            return new E_RdfTerm((Expr)NodeValue.makeDecimal((long)1L), (Expr)expr.getArgs().get(0), (Expr)NodeValue.makeString((String)""), (Expr)NodeValue.makeString((String)""));
        }
        if (expr.getFunctionIRI().equals("http://aksw.org/sparqlify/plainLiteral")) {
            Expr tmp;
            NodeValue lang = NodeValue.makeString((String)"");
            if (expr.getArgs().size() == 2 && (tmp = (Expr)expr.getArgs().get(1)) != null) {
                lang = tmp;
            }
            return new E_RdfTerm((Expr)NodeValue.makeDecimal((long)2L), (Expr)expr.getArgs().get(0), (Expr)lang, (Expr)NodeValue.makeString((String)""));
        }
        if (expr.getFunctionIRI().equals("http://aksw.org/sparqlify/typedLiteral")) {
            return new E_RdfTerm((Expr)NodeValue.makeDecimal((long)3L), (Expr)expr.getArgs().get(0), (Expr)NodeValue.makeString((String)""), (Expr)expr.getArgs().get(1));
        }
        if (expr.getFunctionIRI().equals("http://aksw.org/sparqlify/blankNode")) {
            return new E_RdfTerm((Expr)NodeValue.makeDecimal((long)0L), (Expr)expr.getArgs().get(0), (Expr)NodeValue.makeString((String)""), (Expr)NodeValue.makeString((String)""));
        }
        return expr;
    }
}

