/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.jena_sparql_api.restriction.RestrictionManagerImpl;
import org.aksw.jena_sparql_api.utils.NodeTransformRenameMap;
import org.aksw.jena_sparql_api.utils.QuadPatternUtils;
import org.aksw.jena_sparql_api.utils.QuadUtils;
import org.aksw.jena_sparql_api.views.IViewDef;
import org.aksw.jena_sparql_api.views.RestrictedExpr;
import org.aksw.jena_sparql_api.views.SparqlSubstitute;
import org.aksw.jena_sparql_api.views.VarDefinition;
import org.aksw.sparqlify.database.Constraint;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVars;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.QuadPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.modify.request.UpdateModify;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlView
implements IViewDef {
    private static final Logger logger = LoggerFactory.getLogger(SparqlView.class);
    private String name;
    private QuadPattern template;
    private VarDefinition varDefinition;
    private ExprList constraints;
    private RestrictionManagerImpl restrictions;
    private Op op;
    private RestrictionManagerImpl varRestrictions = new RestrictionManagerImpl();

    public RestrictionManagerImpl getRestrictions() {
        return this.restrictions;
    }

    public void setRestrictions(RestrictionManagerImpl restrictions) {
        this.restrictions = restrictions;
    }

    @Override
    public Set<Var> getVarsMentioned() {
        HashSet<Var> result = new HashSet<Var>();
        result.addAll(QuadPatternUtils.getVarsMentioned((Iterable)this.template));
        result.addAll(OpVars.mentionedVars((Op)this.op));
        return result;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static SparqlView create(String name, String viewDefStr) {
        String str = viewDefStr.replaceAll("Construct", "Insert ");
        System.out.println("Hack replacement: " + str);
        UpdateRequest request = new UpdateRequest();
        UpdateFactory.parse((UpdateRequest)request, (String)str);
        UpdateModify update = (UpdateModify)request.getOperations().get(0);
        List quads = update.getInsertQuads();
        Element element = update.getWherePattern();
        QuadPattern quadPattern = QuadPatternUtils.create((Iterable)quads);
        SparqlView result = SparqlView.create(name, quadPattern, element);
        return result;
    }

    public static SparqlView create(String name, QuadPattern quadPattern, Element element) {
        Op tmp = Algebra.compile((Element)element);
        Op op = Algebra.toQuadForm((Op)tmp);
        SparqlView result = SparqlView.create(name, quadPattern, op);
        return result;
    }

    public static SparqlView create(String name, QuadPattern quadPattern, Op op) {
        SparqlView result = new SparqlView(name, quadPattern, new ExprList(), new VarDefinition(), op);
        return result;
    }

    public static SparqlView create(String name, Query query) {
        if (!query.isConstructType()) {
            throw new RuntimeException("Query must be a construct query");
        }
        Op tmp = Algebra.compile((Element)query.getQueryPattern());
        Op op = Algebra.toQuadForm((Op)tmp);
        QuadPattern quadPattern = QuadPatternUtils.toQuadPattern((Node)Quad.defaultGraphNodeGenerated, (BasicPattern)query.getConstructTemplate().getBGP());
        SparqlView result = SparqlView.create(name, quadPattern, op);
        return result;
    }

    public static SparqlView create(String name, QuadPattern template, ExprList filters, List<Expr> bindings, List<Constraint> rawConstraints, Op op) {
        if (bindings == null) {
            bindings = new ArrayList<Expr>();
        }
        VarDefinition varDefinition = new VarDefinition();
        for (Expr expr : bindings) {
            if (!(expr instanceof E_Equals)) {
                throw new RuntimeException("Binding expr must have form ?var = ... --- instead got: " + expr);
            }
            Expr definition = expr.getFunction().getArg(2);
            definition = SparqlSubstitute.substituteExpr(definition);
            RestrictedExpr restExpr = new RestrictedExpr(definition);
            Var var = expr.getFunction().getArg(1).asVar();
            varDefinition.getMap().put((Object)var, (Object)restExpr);
        }
        if (rawConstraints == null) {
            rawConstraints = Collections.emptyList();
        }
        ExprList constraints = new ExprList();
        logger.warn("Derivation of restrictions from expressions currently not implemented");
        return new SparqlView(name, template, constraints, varDefinition, op);
    }

    public SparqlView(String name, QuadPattern template, ExprList constraints, VarDefinition varDefinition, Op op) {
        this.name = name;
        this.template = template;
        this.varDefinition = varDefinition;
        this.constraints = constraints;
        this.op = op;
    }

    @Deprecated
    public QuadPattern getQuadPattern() {
        return this.template;
    }

    @Deprecated
    public Map<Node, Expr> getBinding() {
        throw new RuntimeException("deprecated and removed");
    }

    public Op getOp() {
        return this.op;
    }

    public ExprList getConstraints() {
        return this.constraints;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparqlView other = (SparqlView)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    @Override
    public QuadPattern getTemplate() {
        return this.template;
    }

    @Override
    public RestrictionManagerImpl getVarRestrictions() {
        return this.varRestrictions;
    }

    @Override
    public VarDefinition getVarDefinition() {
        return this.varDefinition;
    }

    @Deprecated
    public SparqlView copySubstitute(Map<Node, Node> renamer) {
        throw new RuntimeException("not there anymore");
    }

    @Override
    public SparqlView copyRenameVars(Map<Var, Var> oldToNew) {
        HashMap<Var, Var> map = new HashMap<Var, Var>();
        for (Map.Entry<Var, Var> entry : oldToNew.entrySet()) {
            map.put(entry.getKey(), entry.getValue());
        }
        ExprList tmpFilter = new ExprList();
        NodeTransformRenameMap rename = new NodeTransformRenameMap(map);
        for (Object expr : this.constraints) {
            tmpFilter.add(expr.applyNodeTransform((NodeTransform)rename));
        }
        BindingHashMap bindingMap = new BindingHashMap();
        for (Map.Entry entry : map.entrySet()) {
            bindingMap.add((Var)entry.getKey(), (Node)entry.getValue());
        }
        NodeTransformRenameMap renamer = new NodeTransformRenameMap(map);
        Op op = NodeTransformLib.transform((NodeTransform)renamer, (Op)this.op);
        SparqlView result = new SparqlView(this.name, QuadUtils.copySubstitute((QuadPattern)this.template, map), this.constraints.copySubstitute((Binding)bindingMap), null, op);
        return result;
    }
}

