/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.views;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ValueSet<T> {
    private Set<T> values;
    private boolean isPositive;

    public ValueSet(Set<T> values) {
        this.values = values;
        this.isPositive = true;
    }

    public ValueSet(boolean isPositive, Set<T> values) {
        this.values = values;
        this.isPositive = isPositive;
    }

    public static <T> ValueSet<T> create(boolean isPositive, T ... values) {
        HashSet<T> v = new HashSet<T>(Arrays.asList(values));
        ValueSet<T> result = new ValueSet<T>(isPositive, v);
        return result;
    }

    public ValueSet<T> intersect(ValueSet<T> that) {
        HashSet<T> set = new HashSet<T>();
        boolean isPos = true;
        if (this.isPositive) {
            if (that.isPositive) {
                set.addAll(this.values);
                set.retainAll(that.values);
            } else {
                set.addAll(this.values);
                set.removeAll(that.values);
            }
        } else if (that.isPositive) {
            set.addAll(that.values);
            set.removeAll(this.values);
        } else {
            set.addAll(this.values);
            set.addAll(that.values);
            isPos = false;
        }
        ValueSet result = new ValueSet(isPos, set);
        return result;
    }

    public ValueSet<T> union(ValueSet<T> that) {
        HashSet<T> set = new HashSet<T>();
        boolean isPos = true;
        if (this.isPositive) {
            if (that.isPositive) {
                set.addAll(this.values);
                set.addAll(that.values);
            } else {
                set.addAll(that.values);
                set.removeAll(this.values);
                isPos = false;
            }
        } else if (that.isPositive) {
            set.addAll(this.values);
            set.removeAll(that.values);
            isPos = false;
        } else {
            set.addAll(this.values);
            set.retainAll(that.values);
        }
        ValueSet result = new ValueSet(isPos, set);
        return result;
    }

    public ValueSet<T> negate() {
        ValueSet<T> result = new ValueSet<T>(!this.isPositive, this.values);
        return result;
    }

    public boolean isEmpty() {
        return this.isPositive && this.values.isEmpty();
    }

    public boolean contains(Object item) {
        boolean isContained = this.values.contains(item);
        boolean result = this.isPositive ? isContained : !isContained;
        return result;
    }

    public String toString() {
        String polarity = this.isPositive ? "+" : "-";
        return polarity + this.values;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.isPositive ? 1231 : 1237);
        result = 31 * result + (this.values == null ? 0 : this.values.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueSet other = (ValueSet)obj;
        if (this.isPositive != other.isPositive) {
            return false;
        }
        return !(this.values == null ? other.values != null : !this.values.equals(other.values));
    }
}

