/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.views.index;

import java.util.ArrayList;
import java.util.Collections;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.function.BinaryOperator;
import org.aksw.jena_sparql_api.utils.model.Quadlet;
import org.aksw.jena_sparql_api.views.index.CandidateViewSelectorImpl;

public class QuadPrefixes {
    public static final QuadPrefixes ALWAYS_MATCHING = QuadPrefixes.createAlwaysMatching();
    protected Quadlet<? extends NavigableSet<String>> prefixes;
    protected boolean mayBeObjectLiteral;
    protected boolean mayBeObjectResource;

    public QuadPrefixes(Quadlet<? extends NavigableSet<String>> prefixes, boolean mayBeObjectResource, boolean mayBeObjectLiteral) {
        this.prefixes = prefixes;
        this.mayBeObjectLiteral = mayBeObjectLiteral;
        this.mayBeObjectResource = mayBeObjectResource;
    }

    public Quadlet<? extends NavigableSet<String>> getPrefixes() {
        return this.prefixes;
    }

    public boolean isMayBeObjectLiteral() {
        return this.mayBeObjectLiteral;
    }

    public boolean isMayBeObjectResource() {
        return this.mayBeObjectResource;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mayBeObjectLiteral ? 1231 : 1237);
        result = 31 * result + (this.mayBeObjectResource ? 1231 : 1237);
        result = 31 * result + (this.prefixes == null ? 0 : this.prefixes.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        QuadPrefixes other = (QuadPrefixes)obj;
        if (this.mayBeObjectLiteral != other.mayBeObjectLiteral) {
            return false;
        }
        if (this.mayBeObjectResource != other.mayBeObjectResource) {
            return false;
        }
        return !(this.prefixes == null ? other.prefixes != null : !this.prefixes.equals(other.prefixes));
    }

    public String toString() {
        return "PrefixDescription [prefixes=" + this.prefixes + ", mayBeObjectLiteral=" + this.mayBeObjectLiteral + ", mayBeObjectResource=" + this.mayBeObjectResource + "]";
    }

    public static QuadPrefixes createAlwaysMatching() {
        TreeSet<String> x = new TreeSet<String>(Collections.singleton(""));
        QuadPrefixes result = new QuadPrefixes((Quadlet<? extends NavigableSet<String>>)new Quadlet(x, x, x, x), true, true);
        return result;
    }

    public static QuadPrefixes intersect(QuadPrefixes a, QuadPrefixes b) {
        QuadPrefixes result = QuadPrefixes.applyOp(a, b, CandidateViewSelectorImpl::intersectPrefixes, Boolean::logicalAnd);
        return result;
    }

    public static QuadPrefixes union(QuadPrefixes a, QuadPrefixes b) {
        QuadPrefixes result = QuadPrefixes.applyOp(a, b, CandidateViewSelectorImpl::unionPrefixes, Boolean::logicalOr);
        return result;
    }

    public static QuadPrefixes applyOp(QuadPrefixes a, QuadPrefixes b, BinaryOperator<NavigableSet<String>> prefixOp, BinaryOperator<Boolean> booleanOp) {
        Quadlet<? extends NavigableSet<String>> pa = a.getPrefixes();
        Quadlet<? extends NavigableSet<String>> pb = b.getPrefixes();
        int n = pa.size();
        ArrayList<NavigableSet> components = new ArrayList<NavigableSet>(4);
        for (int i = 0; i < n; ++i) {
            NavigableSet pas = (NavigableSet)pa.get(i);
            NavigableSet pbs = (NavigableSet)pb.get(i);
            NavigableSet c = (NavigableSet)prefixOp.apply(pas, pbs);
            components.add(c);
        }
        Quadlet quadlet = new Quadlet(components);
        boolean mayBeResource = (Boolean)booleanOp.apply(a.isMayBeObjectResource(), b.isMayBeObjectResource());
        boolean mayBeLiteral = (Boolean)booleanOp.apply(a.isMayBeObjectLiteral(), b.isMayBeObjectLiteral());
        QuadPrefixes result = new QuadPrefixes((Quadlet<? extends NavigableSet<String>>)quadlet, mayBeResource, mayBeLiteral);
        return result;
    }
}

