/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.util.Pair;

public class IndirectEquiMap<K, V> {
    private Map<K, Integer> keyToToken = new HashMap<K, Integer>();
    private Multimap<Integer, K> tokenToKeys = HashMultimap.create();
    private Map<Integer, V> tokenToValue = new HashMap<Integer, V>();
    private int nextToken = 0;

    public Set<K> keySet() {
        return this.keyToToken.keySet();
    }

    public Multimap<Integer, K> getEquivalences() {
        return this.tokenToKeys;
    }

    public Collection<K> getEquivalences(K key) {
        return this.tokenToKeys.get((Object)this.keyToToken.get(key));
    }

    private void putKeyToken(K key, int token) {
        this.keyToToken.put(key, token);
        this.tokenToKeys.put((Object)token, key);
    }

    public void stateEqual(K a, K b, V value) {
        this.stateEqual(a, b, value, true);
    }

    public Pair<V, V> stateEqual(K a, K b) {
        return this.stateEqual(a, b, null, false);
    }

    public void stateEqual(Collection<K> keys, V value) {
        int newToken = ++this.nextToken;
        for (K key : keys) {
            Integer oldToken = this.keyToToken.get(key);
            if (oldToken != null) {
                this.tokenToValue.remove(oldToken);
                this.tokenToKeys.putAll((Object)newToken, (Iterable)this.tokenToKeys.get((Object)oldToken));
                this.tokenToKeys.removeAll((Object)oldToken);
            }
            this.putKeyToken(key, newToken);
        }
        this.tokenToValue.put(newToken, value);
    }

    private Pair<V, V> stateEqual(K a, K b, V value, boolean overwrite) {
        Integer ta = this.keyToToken.get(a);
        Integer tb = this.keyToToken.get(b);
        if (ta == null) {
            if (tb == null) {
                int token = ++this.nextToken;
                this.putKeyToken(a, token);
                this.putKeyToken(b, token);
            } else {
                this.putKeyToken(a, tb);
            }
        } else if (tb == null) {
            this.putKeyToken(b, ta);
        } else {
            V va = this.tokenToValue.get(ta);
            V vb = this.tokenToValue.get(tb);
            if (va != null && vb != null && !va.equals(vb)) {
                if (overwrite) {
                    va = value;
                } else {
                    return Pair.create(va, vb);
                }
            }
            if (va == null) {
                va = vb;
            }
            ArrayList ka = new ArrayList(this.tokenToKeys.get((Object)ta));
            ArrayList kb = new ArrayList(this.tokenToKeys.get((Object)tb));
            if (kb.size() > ka.size()) {
                ArrayList tmp = ka;
                ka = kb;
                kb = tmp;
                int tt = ta;
                ta = tb;
                tb = tt;
            }
            for (Object k : kb) {
                this.tokenToKeys.remove((Object)tb, k);
                this.putKeyToken(k, ta);
            }
            if (va != null) {
                this.tokenToValue.put(ta, va);
            }
        }
        return null;
    }

    public void put(K key, V value) {
        Integer token = this.keyToToken.get(key);
        if (token == null) {
            token = ++this.nextToken;
            this.keyToToken.put(key, token);
        }
        this.tokenToValue.put(token, value);
        this.tokenToKeys.put((Object)token, key);
    }

    public V get(K key) {
        Integer token = this.keyToToken.get(key);
        if (token == null) {
            return null;
        }
        return this.tokenToValue.get(token);
    }

    public boolean isEqual(K a, K b) {
        Integer ta = this.keyToToken.get(a);
        return ta != null && ta.equals(this.keyToToken.get(b));
    }

    public String toString() {
        String result = "[";
        boolean isFirst = true;
        for (Map.Entry entry : this.tokenToKeys.asMap().entrySet()) {
            if (!isFirst) {
                result = result + ", ";
            }
            result = result + entry.getValue() + ": " + this.tokenToValue.get(entry.getKey());
        }
        result = result + "]";
        return result;
    }
}

