/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import org.aksw.jena_sparql_api.restriction.RestrictionManagerImpl;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.writers.WriterOp;
import org.apache.jena.sparql.util.NodeIsomorphismMap;

public class OpExtFilterIndexed
extends OpExt {
    protected Op subOp;
    protected RestrictionManagerImpl restrictions;

    public Op getSubOp() {
        return this.subOp;
    }

    public RestrictionManagerImpl getRestrictions() {
        return this.restrictions;
    }

    public OpExtFilterIndexed(Op subOp, RestrictionManagerImpl restrictions) {
        super("OpExtFilterIndexed");
        this.subOp = subOp;
        this.restrictions = restrictions;
    }

    public Op effectiveOp() {
        return OpFilter.filterBy((ExprList)this.restrictions.getExprs(), (Op)this.subOp);
    }

    public QueryIterator eval(QueryIterator input, ExecutionContext execCxt) {
        return null;
    }

    public void outputArgs(IndentedWriter out, SerializationContext sCxt) {
        int line = out.getRow();
        out.println("[Restrictions: " + this.restrictions + "]");
        WriterOp.output((IndentedWriter)out, (Op)this.subOp, (SerializationContext)sCxt);
        if (line != out.getRow()) {
            out.ensureStartOfLine();
        }
    }

    public int hashCode() {
        return 0;
    }

    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpExtFilterIndexed)) {
            return false;
        }
        OpExtFilterIndexed opFilter = (OpExtFilterIndexed)other;
        if (!this.restrictions.equals(opFilter.restrictions)) {
            return false;
        }
        return this.getSubOp().equalTo(opFilter.getSubOp(), labelMap);
    }
}

