/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.sparqlify.database;

import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.aksw.jena_sparql_api.views.Constraint;
import org.aksw.jena_sparql_api.views.PrefixSet;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;

public class PrefixConstraint
implements Constraint {
    private Var var;
    private String attribute;
    private PrefixSet prefixes;

    public PrefixConstraint(Var var, String attribute, String prefix) {
        this.var = var;
        this.attribute = attribute;
        this.prefixes = new PrefixSet(prefix);
    }

    public PrefixConstraint(Var var, String attribute, List<String> prefixes) {
        this.var = var;
        this.attribute = attribute;
        this.prefixes = new PrefixSet(new TreeSet<String>(prefixes));
    }

    public PrefixConstraint(Var var, String attribute, PrefixSet prefixes) {
        this.var = var;
        this.attribute = attribute;
        this.prefixes = prefixes;
    }

    @Override
    public PrefixConstraint copySubstitute(Map<? extends Node, Node> map) {
        Var value = (Var)map.get(this.var);
        if (value == null || this.var.equals((Object)value)) {
            return this;
        }
        return new PrefixConstraint(value, this.attribute, this.prefixes);
    }

    public Var getVar() {
        return this.var;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public PrefixSet getPrefixes() {
        return this.prefixes;
    }

    public String toString() {
        return "PrefixConstraint [var=" + this.var + ", attribute=" + this.attribute + ", prefixes=" + this.prefixes + "]";
    }
}

